#!/usr/bin/perl
# "@(#)87   1.2   src/hmcpok/exp_restrict/hw_errpt.pl, fnm, hmcpok_rel3, rel3s013a 2/7/05 07:40:22"
#
# Author: Dawn Moyer


####################################################################
#
#  MAIN
#
####################################################################
use Getopt::Std;
use Time::Local;
$VERSION="1.0";
$input_args=@$ARGV;


#-------------------------------------------------------------------
# Default Mandatory Input Files
#-------------------------------------------------------------------
$Default_Event_Log_Summary_File = "/var/hsc/log/iqyylog.log";
$Default_ELA_Config_file        = "/opt/ccfw/data/pa/config_FRS.xml";


print "================================================================================\n";
print "Version:    $VERSION                                                            \n";
print "\n"; 
print "Invocation: hw_errpt.pl @ARGV                                                   \n";

#-------------------------------------------------------------------
# Process input options
#-------------------------------------------------------------------
getopts("i:c:t:g:sSLh");

if ( $opt_h ne "" ) {
  StateFormat();
  exit;
}
if ( $opt_i ne "" ) {
        $EVENT_LOG_SUMMARY_FILE=$opt_i;
} else {
        $EVENT_LOG_SUMMARY_FILE=$Default_Event_Log_Summary_File;
}
if ( $opt_c ne "" ) {
        $ELA_CONFIG_FILE=$opt_c;
} else {
        $ELA_CONFIG_FILE=$Default_ELA_Config_file ;
}
if ( $opt_L ne "" ) {
  $displaylocs="Y";
} else {
  $displaylocs="N";
}
if ( $opt_S ne "" ) {
  $supressSFP="Y";
} else {
  $supressSFP="N";
}
if ( $opt_s ne "" ) {
  $slowpool="Y";
} else {
  $slowpool="N";
}
if (( $opt_t ne "" ) && ( $opt_t !~ /(\d*)\/(\d*)\/(\d*) (\d*):(\d*):(\d*)/ )) {
  StateFormat();
  exit;
}
$cutoff_time=$opt_t;
if ( $opt_t ne "" ) {
  $cutoff_epoch=epochTime($cutoff_time);
} else {
  $cutoff_epoch=0;
}
if (( $opt_g ne "" ) && ( $opt_g !~ /(\d+)/ )) {
  StateFormat();
  exit;
}
$global_timeout=$opt_g;
if ( $opt_g ne "" ) {
  $global_timeout=$opt_g;
} else {
  $global_timeout=0;
}


#-------------------------------------------------------------------
# Write header and help instructions for ALL reports
#-------------------------------------------------------------------
if ( !(-e $EVENT_LOG_SUMMARY_FILE) ) {
  print "\n"; 
  print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
  print "<< ERROR >> Mandatory Input File $EVENT_LOG_SUMMARY_FILE                     \n";
  print "            does NOT EXIST!                                                  \n\n";
  print "            The default filename can be overriden using the -i option        \n";
  print "            Use -h option for details                                        \n\n";
  print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
}
if ( !(-e $ELA_CONFIG_FILE) ) {
  print "\n"; 
  print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n";
  print "<< ERROR >> Mandatory Input File $ELA_CONFIG_FILE                               \n";
  print "            does NOT EXIST!                                                     \n\n";
  print "            The default filename can be overriden using the -i option           \n";
  print "            Use -h option for details                                           \n\n";
  print "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
}
if ( !(-e $ELA_CONFIG_FILE) || !(-e $EVENT_LOG_SUMMARY_FILE) ) {
  exit;
}
print "            System Event Log file   = $EVENT_LOG_SUMMARY_FILE                   \n";
print "            ELA Configuaration file = $ELA_CONFIG_FILE                          \n";
print "================================================================================\n\n";
# print "WARNING MESSAGES:\n";
print "________________________________________________________________________________\n";                 
print "                                                                                \n";
print "                     P R O B L E M   D E T E R M I N A T I O N                  \n";
print "________________________________________________________________________________\n";                 
print "                                                                                \n";
print " - Using reports to identify bad suspect HW and ELA reporting to SFP problems   \n";
print "   -----------------------------------------------------------------------------\n";
print "   1. Goto SECTION1 Event Summary Report                                        \n";     
print "   2. View the last field (ELA rep SFP) for each Event. A value of Y for yes    \n";                 
print "      signifies that ELA should have reported this HW event to SFP.             \n";
print "   3. Skip to the detailed data for each identified problem Event by using the  \n";
print "      Event number fast path listed below and follow the recommended actions    \n";
print "      for the associated logical location(s).                                   \n";
print "   4. Use lsswtopol and lsswendpt commands or FNM GUI to map logical to         \n";
print "      physical locations.                                                       \n";
print "   5. The SFP output for all open HMC Events is provided in SECTION3 to aid in  \n";
print "      determining if this Event's Refcode was reported (6th field delimited by  \n";
print "      commas under FRUList keyword) on date in question (under Nodes keyword).  \n";
print "                                                                                \n";
print " - Fast Path Searches                                                           \n";
print "   ------------------                                                           \n";
print "   1. SECTION                                                                   \n";
print "      To skip between all 3 Reports (Event Summary/Event Details/SFP Open HMC   \n";  
print "      Events)                                                                   \n";
print "   2. (n=specific Event number)                                                 \n"; 
print "      To skip between Event Summary and Event Details Report for a specific     \n";     
print "      Event number                                                              \n";
print "   3. Pool_n                                                                    \n";
print "      To skip between Event Summary and Event Details Report for a specific     \n";
print "      Pool number                                                               \n";   
print "                                                                                \n";
print " *Note: ELA analyzes Event relationships within a given Pool (e.g. Event        \n";
print "        elimination). If it appears that related Events are flowing into the    \n";
print "        next Pool causing dubious Events to be identified as problems,          \n"; 
print "        rerun report as follows                                                 \n";
print "        hw_errpt.pl -s                                                          \n";
print "                  or                                                            \n";
print "        hw_errpt.pl -s -g 1200                                                  \n";
print "________________________________________________________________________________\n\n";                 


#-------------------------------------------------------------------
# Get Event Summary Log data passed to ELA.
# Get ELA Config data associated with Events from Event Summary Log.
# This is the Complete and ONLY data passed to ELA for analysis. 
#-------------------------------------------------------------------
$evtnum=0;
getSummaryLogData();
getConfigData();


#-------------------------------------------------------------------
# - Calculate Pools with the first and last Event in each Pool based
#   on each Event's time-out. Don't include time-outs of Duplicate
#   Events within a specific Pool. This may cause the Pool to never 
#   time-out (e.g. bouncing link Events).
# - Calculate and set Duplicate Events within a specfic to the Pool.
#   Oldest Event prevails (Always shares same priority). This is true 
#   for ALL events (Alerts...etc).
# - Calculate Hot Threshold for each Event.
#-------------------------------------------------------------------
$new_pool="Y";
$pool_num=0;
for ($i = 1; $i <= $evtnum; $i++) {
  $seq_tds[$i]= "($i)  $evt_LogTimeStamp[$i]\n";
  #---------------------------------------------------------------
  # Set FIP Event
  #---------------------------------------------------------------
  if ($new_pool eq "Y") {
    $pool_num ++;
    $new_pool="N";
    $pool_timeout=epochTime($evt_LogTimeStamp[$i]) + $config_Timeout[$i];      
    $evt_FIP[$pool_num]=$i;
    #print "Pool=$pool_num & FIP=$evt_FIP[$pool_num]\n"; 
  } 
  #---------------------------------------------------------------
  # Compare new Event in the Pool to all Events in Pool thus far
  # for Dups. $i is dup event and $j is origional.
  #---------------------------------------------------------------
  for ($j = $evt_FIP[$pool_num]; $j <= $i; $j++) {
    $DeviceLoc=getDeviceLoc($j);
    if (($Dup_evt[$i] eq "N") && ($i != $j)) {
      $evt_Class=substr($evt_LogId[$i],0,2);
      if ( $evt_Class ne "BC" ) {
        if ( ($evt_LogId[$i] eq $evt_LogId[$j]) && ($evt_DevLoc[$i] eq $evt_DevLoc[$j]) ) {
          $Dup_evt[$i]="Y";
          $Dup_evt_num[$j]++;
          if ($Dup_evt_num[$j] >= $config_HotThreshold[$j]) { 
            $Hot_evt_threshold[$j]="Y";
          }
          $Dup_evt_of[$i]=$j;
          $seq_tds[$j]= "$seq_tds[$j]                           ($i)  $evt_LogTimeStamp[$i]\n";
        }
      } else {
        if ( ($evt_LogId[$i] eq $evt_LogId[$j]) && ($evt_SRN[$i] eq $evt_SRN[$j]) ) {
          $Dup_evt[$i]="Y";
          $Dup_evt_num[$j]++;
          if ($Dup_evt_num[$j] >= $config_HotThreshold[$j]) { 
            $Hot_evt_threshold[$j]="Y";
          }
          $Dup_evt_of[$i]=$j;
          $seq_tds[$j]= "$seq_tds[$j]                           ($i)  $evt_LogTimeStamp[$i]\n";
        }
      }
    }
  } 
  #---------------------------------------------------------------
  # If not a Duplicate Event then determine if new pool time-out
  #---------------------------------------------------------------
  if ($Dup_evt[$i] ne "Y") {
    $event_pool_timeout=epochTime($evt_LogTimeStamp[$i]) + $config_Timeout[$i];
    if ($slowpool eq "Y") {
      if ($event_pool_timeout >= $pool_timeout) {
        $pool_timeout=$event_pool_timeout;
      }
    } else {
      if ($pool_timeout <= $earliest_pool_timeout) {
        $pool_timeout=$event_pool_timeout;
      }
    }
  }
  #---------------------------------------------------------------
  # Get the next Event in pool and test for LIP.
  #---------------------------------------------------------------
  $next_event_pool_timeout=epochTime($evt_LogTimeStamp[$i+1]);
  if ( ($next_event_pool_timeout > $pool_timeout) | ($i==$evtnum) ){
    $evt_LIP[$pool_num]=$i;
    $new_pool="Y";
    # print "Pool_num=$pool_num & LIP=$evt_LIP[$pool_num]\n";
  } 
} 
$evt_LIP[$pool_num]=$evtnum;
$num_pools=$pool_num;


#-------------------------------------------------------------------
# - Calculate the New Events List for the entire Pool.
# - Calculate Endpt and Device Elimintaion for each Event within a       
#   given Pool. Don't Include Dups or Hot Threshold met Events.            
#-------------------------------------------------------------------
for ($pool_num = 1; $pool_num <= $num_pools; $pool_num++) {
  #-----------------------------------------------------------------
  # Compare every Event in the Pool to all Events in the Pool
  #-----------------------------------------------------------------
  for ($j = $evt_FIP[$pool_num]; $j <= $evt_LIP[$pool_num]; $j++) {
    #---------------------------------------------------------------
    # Calculate Elimintaion string for each event in Pool  
    #---------------------------------------------------------------
    for ($k = $evt_FIP[$pool_num]; $k <= $evt_LIP[$pool_num]; $k++) {
      if ($j != $k) { 
        $DeviceLoc=getDeviceLoc($k);
        $DeviceElim="$k<$config_EliminationLevel[$k]>    "; 
        $DeviceElim=substr($DeviceElim,0,10);
        $DeviceElim_seq=$k;
        # print "evt_DevEndptLocs[$j] = $evt_DevEndptLocs[$j]\n";
        #-------------------------------------------------------------
        # Calculate Endpt Elimintaion string 
        #-------------------------------------------------------------
        $IncludeEndpt="N";
        @Endpt_List=split(/,/ ,$evt_DevEndptLocs[$j]);
        if ($#Endpt_List >= 0) {
          for ($l = 0; $l <= $#Endpt_List; $l++) {
            # print "$j config_EliminationLevel[$k]=$config_EliminationLevel[$k]\n";
            # print "$j evt_DevLoc[$k]=$evt_DevLoc[$k] Endpt_List[$l]=$Endpt_List[$l]\n \n";
            if ( ($config_EliminationLevel[$k] eq "FRAME") &&
                 (substr($evt_DevLoc[$k],6,3) eq substr($Endpt_List[$l],6,3)) ) {
              $IncludeEndpt="Y";
            }
            if ( ($config_EliminationLevel[$k] eq "CAGE") &&
                 (substr($evt_DevLoc[$k],6,5) eq substr($Endpt_List[$l],6,5)) ) {
              $IncludeEndpt="Y";
            }
            if ( ($config_EliminationLevel[$k] eq "CARD") &&
                 (substr($evt_DevLoc[$k],6,8) eq substr($Endpt_List[$l],6,8)) ) {
              $IncludeEndpt="Y";
            }
            if ( ($config_EliminationLevel[$k] eq "CHIP") &&
                 (substr($evt_DevLoc[$k],6,9) eq substr($Endpt_List[$l],6,9)) ) {
              $IncludeEndpt="Y";
            }
            if ( ($config_EliminationLevel[$k] eq "PORT") &&
                 (substr($evt_DevLoc[$k],6,10) eq substr($Endpt_List[$l],6,10)) ) { 
              $IncludeEndpt="Y";
            }
          }
          # $IncludeEndpt = "Y";
          if (($config_EP_affectedIDs[$k] =~ /$evt_LogId[$j]/) && ($IncludeEndpt eq "Y")) {
            if (($Dup_evt[$k] ne "Y") && ($Hot_evt_threshold[$j] ne "Y")) {
              $evt_endpt_elim_by[$j]="$evt_endpt_elim_by[$j]\n        - $DeviceElim$DeviceLoc";
              $evt_endpt_elim_by_seq[$j]="$evt_endpt_elim_by_seq[$j],$k";
            }
          }
        }  
        #-----------------------------------------------------------
        # Calculate Local Device Elimintaion string 
        #-----------------------------------------------------------
        # print "$j config_EliminationLevel[$k]=$config_EliminationLevel[$k]\n";
        # print "$j evt_DevLoc[$k]=$evt_DevLoc[$k] This_evt_DevLoc[$j]=$evt_DevLoc[$j]\n";
        $IncludeLD="N";
        if ( ($config_EliminationLevel[$k] eq "FRAME") &&
             (substr($evt_DevLoc[$k],6,3) eq substr($evt_DevLoc[$j],6,3)) ) {
          $IncludeLD="Y";
        }
        if ( ($config_EliminationLevel[$k] eq "CAGE") &&
             (substr($evt_DevLoc[$k],6,5) eq substr($evt_DevLoc[$j],6,5)) ) {
          $IncludeLD="Y";
        }
        if ( ($config_EliminationLevel[$k] eq "CARD") &&
             (substr($evt_DevLoc[$k],6,8) eq substr($evt_DevLoc[$j],6,8)) ) {
          $IncludeLD="Y";
        }
        if ( ($config_EliminationLevel[$k] eq "CHIP") &&
             (substr($evt_DevLoc[$k],6,9) eq substr($evt_DevLoc[$j],6,9)) ) {
          $IncludeLD="Y";
        }
        if ( ($config_EliminationLevel[$k] eq "PORT") &&
             (substr($evt_DevLoc[$k],6,10) eq substr($evt_DevLoc[$j],6,10)) ) { 
          $IncludeLD="Y";
        }
        # $IncludeLD = "Y";
        if (($config_LD_affectedIDs[$k] =~ /$evt_LogId[$j]/) && ($IncludeLD eq "Y")) {
          if (($Dup_evt[$k] ne "Y") && ($Hot_evt_threshold[$j] ne "Y")) {
            $evt_device_elim_by[$j]="$evt_device_elim_by[$j]\n        - $DeviceElim$DeviceLoc";
            $evt_device_elim_by_seq[$j]="$evt_device_elim_by_seq[$j],$k";
          }
        }
      }
    } 
  } 
}


#-------------------------------------------------------------------
# - Calculate and eliminate ONLY 1 Event when 2 events eliminate one 
#   another. Highest Priority Event will prevail. If Same Priority
#   Earliest Event will prevail.
#-------------------------------------------------------------------
for ($pool_num = 1; $pool_num <= $num_pools; $pool_num++) {
  for ($i = $evt_FIP[$pool_num]; $i <= $evt_LIP[$pool_num]; $i++) {
    if ($evt_endpt_elim_by_seq[$i] ne "") {
      @ESeq_List=split(/,/ ,$evt_endpt_elim_by_seq[$i]);
      if ($#ESeq_List >= 0) {
        for ($j = 1; $j <= $#ESeq_List; $j++) {
          if ($evt_endpt_elim_by_seq[$ESeq_List[$j]] =~ /$i/) {
            # print "EP Found> Evt $i is eliminated $ESeq_List[$j] & Evt $ESeq_List[$j] is eliminated by $i\n";
            if ($config_Priority[$i] < $config_Priority[$ESeq_List[$j]]) {
              $evt_endpt_elim_by[$i]     =~ s/\n        - $ESeq_List[$j].*//;
              $evt_endpt_elim_by_seq[$i] =~ s/\,$ESeq_List[$j]//;
            } 
            if ($config_Priority[$i] == $config_Priority[$ESeq_List[$j]]) {
              if (epochTime($evt_LogTimeStamp[$i]) <= epochTime($evt_LogTimeStamp[$ESeq_List[$j]])) {
                $evt_endpt_elim_by[$i]     =~ s/\n        - $ESeq_List[$j].*//;
                $evt_endpt_elim_by_seq[$i] =~ s/\,$ESeq_List[$j]//;
              }
            } 
          }
        }
      }
    }
    if ($evt_device_elim_by_seq[$j] ne "") {
      @ESeq_List=split(/,/ ,$evt_device_elim_by_seq[$i]);
      if ($#DSeq_List >= 0) {
        for ($j = 1; $j <= $#DSeq_List; $j++) {
          if ($evt_endpt_elim_by_seq[$DSeq_List[$j]] =~ /$i/) {
            # print "LD Found> Evt $i is eliminated $DSeq_List[$j] & Evt $DSeq_List[$j] is eliminated by $i\n";
            if ($config_Priority[$i] < $config_Priority[$DSeq_List[$j]]) {
              $evt_endpt_elim_by[$i]     =~ s/\n        - $DSeq_List[$j].*//;
              $evt_endpt_elim_by_seq[$i] =~ s/\,$DSeq_List[$j]//;
            } 
            if ($config_Priority[$i] == $config_Priority[$DSeq_List[$j]]) {
              if (epochTime($evt_LogTimeStamp[$i]) <= epochTime($evt_LogTimeStamp[$DSeq_List[$j]])) {
                $evt_endpt_elim_by[$i]     =~ s/\n        - $DSeq_List[$j].*//;
                $evt_endpt_elim_by_seq[$i] =~ s/\,$DSeq_List[$j]//;
              }
            } 
          }
        }  
      }
    }
  }
}
for ($i = 1; $i <= $evtnum; $i++) {
  if (($evt_endpt_elim_by_seq[$i] ne "") || ($evt_device_elim_by_seq[$i] ne "")) {
    $evt_eliminated[$i] = "Y";
  }
}


#-------------------------------------------------------------------
# Calculate the New Events Met for the entire Pool.
#-------------------------------------------------------------------
for ($pool_num = 1; $pool_num <= $num_pools; $pool_num++) {
  #---------------------------------------------------------------
  # Calculate the New Events List for the Entire Pool. 
  #---------------------------------------------------------------
  $first_ANE_Pool = "T";
  for ($j = $evt_FIP[$pool_num]; $j <= $evt_LIP[$pool_num]; $j++) {
    $tmp_config_AssociatedNewevents = $config_AssociatedNewevents[$j];
    $tmp_config_AssociatedNewevents =~ s/\{//g;
    $tmp_config_AssociatedNewevents =~ s/\}//g;
    $tmp_config_AssociatedNewevents =~ s/ *//g;
    @ANE_List=split(/,/ ,$tmp_config_AssociatedNewevents);
    if (($#ANE_List >= 0) && ($Dup_evt[$j] ne "Y") && ($evt_eliminated[$j] ne "Y")) {
      # Id 1st Event with and ANE list then add entire list
      if ( $first_ANE_Pool eq "T" ) { 
        $Pool_ANE_List[$pool_num] = $tmp_config_AssociatedNewevents;
        $first_ANE_Pool = "F";
        # print ">>--FIRST Pool $pool_num Event=$j List == $Pool_ANE_List[$pool_num]\n";
      } else {
        # Don't add if duplicate ANE Event
        for ($k = 0; $k <= $#ANE_List; $k++) {
          if ( $Pool_ANE_List[$pool_num] !~ /$ANE_List[$k]/ ) {
            $Pool_ANE_List[$pool_num] = $Pool_ANE_List[$pool_num], $ANE_List[$k];
            # print ">>--NEXT Pool $pool_num Event=$j List == $Pool_ANE_List[$pool_num]\n";
          }
        }
      }
    } 
  }
  #---------------------------------------------------------------
  # Sort the New EventIds List for the Entire Pool by Priority Level. 
  #---------------------------------------------------------------
  @AE_evt_LogId=split(/,/ ,$Pool_ANE_List[$pool_num]);
  if ($#AE_evt_LogId >= 0) {
    getAE_ConfigData();
    for ($j = 0; $j <= $#AE_evt_LogId; $j++) {
      for ($k = 0; $k <= $#AE_evt_LogId; $k++) {
        if ($AE_config_Priority[$j] < $AE_config_Priority[$k]) {
          $sav_AE_evt_LogId          = $AE_evt_LogId[$j];
          $sav_AE_config_Priority    = $AE_config_Priority[$j];
          $AE_evt_LogId[$j]          = $AE_evt_LogId[$k];
          $AE_config_Priority[$j]    = $AE_config_Priority[$k];
          $AE_evt_LogId[$k]          = $sav_AE_evt_LogId;
          $AE_config_Priority[$k]    = $sav_AE_config_Priority;
        }
      }
    }
  }
  #---------------------------------------------------------------
  # Calculate New Events. Highest Priory Events (lowest) prevails.
  # Loop on all possible New Events in the Pool.
  #---------------------------------------------------------------
  for ($j = 0; $j <= $#AE_evt_LogId; $j++) {

    $NE_PE_index  = "$pool_num$j"; # unique index for each Event in Pool Location Lists

    # print "pool=$pool_num evt=$j AE_evt_LogId[$j]=$AE_evt_LogId[$j] AE_config_Piority[$j]=$AE_config_Priority[$j]\n";
    #---------------------------------------------------------------
    # Loop on all Events in Pool to determine candidates of New Event
    #---------------------------------------------------------------
    for ($k = $evt_FIP[$pool_num]; $k <= $evt_LIP[$pool_num]; $k++) {
      #---------------------------------------------------------------
      # If THIS New Event is in the Event's associated_newevents list 
      # (config file), not elimainated or a duplicate or already used 
      # in another Higher Priority New Event then test for good loc.
      #---------------------------------------------------------------
      if ( ($config_AssociatedNewevents[$k] =~ /$AE_evt_LogId[$j]/) && 
         ($evt_used_in_NE[$k] eq "N") && ($Dup_evt[$k] eq "N") && ($evt_eliminated[$k] eq "N") ) {
        @NE_evtinfo = split(/:/ ,getAE_Expanded($AE_evt_LogId[$j]));
        $NE_min_num_evts[$NE_PE_index]  = $NE_evtinfo[0];
        @NE_include_class            = split(/,/ ,$NE_evtinfo[1]);
        #---------------------------------------------------------------
        # If Event is in include class (e.g. BB20 Dev) add Location to 
        # Location List for THIS New Event. Loop on all include classes.
        #---------------------------------------------------------------
        for ($l = 0; $l <= $#NE_include_class; $l++) {
          $evt_Class_Type=substr($evt_LogId[$k],0,4);
          # print "Pool=$pool_num  NE=$AE_evt_LogId[$j]  Evt_seq=$k  evt_Class_type=$evt_Class_Type  NE_include_class[$l]=$NE_include_class[$l]\n";
          if ($NE_include_class[$l] =~ /$evt_Class_Type/) {
            if ($NE_include_class[$l] =~ /Dev/) {
              $NE_Loc_List[$NE_PE_index]  = "$NE_Loc_List[$NE_PE_index],$k Dev $evt_DevLoc[$k]";
            } 
            if ($NE_include_class[$l] =~ /Endpt/) {
              $NE_Loc_List[$NE_PE_index] = "$NE_Loc_List[$NE_PE_index],$k Endpt $evt_DevEndptLocs[$k]";
            }
          }
        }
      }
    }
    #---------------------------------------------------------------
    # Invoke New_Event. If New Event is met sets:
    # Global - $evt_used_in_NE[$Seq#]
    #            "BB10F00A-1" (Defaults to "N")  
    #        - $evt_used_in_NE_loctype
    #            "Dev or Endpt"   
    #---------------------------------------------------------------
    New_Event($AE_evt_LogId[$j], $NE_Loc_List[$NE_PE_index], $NE_min_num_evts[$NE_PE_index]);
  }
}


#-------------------------------------------------------------------
# Write Section1 Summary Report 
#-------------------------------------------------------------------
print "\n";
print "================================================================================\n";       
print "\n";
print "SECTION1:           S T A R T    E V E N T    S U M M A R Y                     \n";
# print "Possible Cases                                                                  \n";
# print "-Alerts (Class=BB60xxxx):                               na   na    na          n\n";      
# print "-Power Subsystem Alerts (Class=BC60xxxx):               na   na    na          Y\n";      
# print "-Diagnostic Tests (Class=BB[12345]0F[123]0[1234]):      na   na    na          Y\n";
# print "-Non Alerts and Diags:                                  Y    na    Evt/n       Y\n";       
# print "                                                        n    Seq#  na          n\n";          
# print "                                                        n    n     Evt/n       Y\n";    
print "\n";
print "================================================================================\n";       
print "\n";
print "seq#   Date/Time          EventId   Description        Hot   Elim  Member    ELA\n";    
print "                          Refcode                      Thld  by    of        Rep\n";
print "                                                       Met   Seq#  NewEvent  SFP\n";
print "       Locations(-L opt)                                                        \n";
print "\n";
print "================================================================================\n";       
$pool_num=1;
print "                          ELA  Pool_$pool_num  Events($evt_FIP[$pool_num]-$evt_LIP[$pool_num])\n";    
print "================================================================================\n";
for ($i = 1; $i <= $evtnum; $i++) {
  $evt_Type=substr($evt_LogId[$i],2,1);
  $evt_Class=substr($evt_LogId[$i],0,2);
  #-----------------------------------------------------------------
  # Remove adj and abbreviate large words to reduce description size
  #-----------------------------------------------------------------
  $short_configDesc =  $config_Desc[$i];
  $short_configDesc =~ s/<!-- *//g;
  $short_configDesc =~ s/\(.*\]\) *//;
  $short_configDesc =~ s/ *-->//g;
  $short_configDesc =~ s/\( *//g;
  $short_configDesc =~ s/[Ss]ynchronization/Sync/g;
  $short_configDesc =~ s/[Ee]rror/Err/g;
  $short_configDesc =~ s/[Ss]witch/Swt/g;
  $short_configDesc =~ s/[Aa]dapter/Adapt/g;
  $short_configDesc =~ s/[Rr]eceive[d ]/Recv/g;
  $short_configDesc =~ s/[Ee]xternal/Ext/g;
  $short_configDesc =~ s/[Ll]evel/Lev/g;
  $short_configDesc =~ s/[Cc]annot/!/g;
  $short_configDesc =~ s/[Cc]ritical //g;
  $short_configDesc =~ s/[Ff]ailure //g;
  $short_configDesc =~ s/[Aa]ny //g;
  $short_configDesc =~ s/[Aa]n //g;
  $short_configDesc =~ s/[Tt]he //g;
  $short_configDesc =~ s/  / /g;
  if ($evt_LogId[$i] eq "BB60F0F2") { 
    $short_configDesc="Power down CEC";
  }
  if ($Dup_evt[$i] eq "Y") {
    $short_configDesc="<DUP LocSeq# $Dup_evt_of[$i]>";
  } 
  $short_configDesc=substr($short_configDesc, 0, 17 );
  $pad= substr("                 ", 1, 18-length($short_configDesc));
  $short_configDesc="$short_configDesc$pad";

  $seq_num="($i)   ";
  $seq_num=substr($seq_num, 0, 6);

  if ($evt_used_in_NE[$i] eq "N") {
    $tmp_evt_used_in_NE[$i] = "n";
  } else {
    $tmp_evt_used_in_NE[$i] = $evt_used_in_NE[$i];
  }
  $tmp_evt_used_in_NE[$i]="$tmp_evt_used_in_NE[$i]           ";
  $tmp_evt_used_in_NE[$i]=substr($tmp_evt_used_in_NE[$i], 0, 11);

  #-----------------------------------------------------------------
  # Write out Default Summary for Event (w/o Locations)                                     
  #-----------------------------------------------------------------
  $SVC = "N";
  if ($Dup_evt[$i] eq "Y") {
    print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc -     -     -           -\n";
    $report_SFP[$i] = "NO, this Event is a Duplicate of an earlier Event";
  } else {
    if ($Hot_evt_threshold[$i] eq "Y") {
      print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc Y     na    $tmp_evt_used_in_NE[$i] Y\n";
      $report_SFP[$i] = "YES, this Event has met HOT threshold";
      $SVC = "Y";
    } else {
      if ( $evt_LogId[$i] =~ /BB60.*/ ) {
        print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc na    na    na          n\n";
        $report_SFP[$i] = "NO, this Event ONLY used to Eliminate other Events";
      }
      if (( $evt_LogId[$i] =~ /BC60.*/ ) || ($evt_LogId[$i] =~ /BB[12345]0F[123]0[1234]/)) {
        print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc na    na    na          Y\n";
        $SVC = "Y";
        $report_SFP[$i] = "YES";
      }
      if ( $evt_LogId[$i] =~ /BB[12345789].*/ ) {
        if (($evt_endpt_elim_by[$i] eq "") && ($evt_device_elim_by[$i] eq "")) {
          print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc n     n     $tmp_evt_used_in_NE[$i] Y\n";
          $report_SFP[$i] = "YES";
          $SVC = "Y";
        } 
        if ($evt_endpt_elim_by[$i] ne "") {
          @ESeq_List=split(/,/ ,$evt_endpt_elim_by_seq[$i]);
          if ($#ESeq_List >= 0) {
            for ($j = 1; $j <= $#ESeq_List; $j++) {
              $ESeq_List[$j]="$ESeq_List[$j]    ";
              $ESeq_List[$j]=substr($ESeq_List[$j], 0, 4);
              if ($Dup_evt[$ESeq_List[$j]] ne "Y") {
                $report_SFP[$i] = "NO, this Event Eliminated by another Event";
                if ($j==1) {
                  print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc n     $ESeq_List[$j]  na          n\n";
                } else {
                  print "                                                             $ESeq_List[$j]\n";
                }  
              }
            }
          }
        }
        if ($evt_device_elim_by[$i] ne "") {
          @DSeq_List=split(/,/ ,$evt_device_elim_by_seq[$i]);
          if ($#DSeq_List >= 0) {
            for ($j = 1; $j <= $#DSeq_List; $j++) {
              $DSeq_List[$j]="$DSeq_List[$j]    ";
              $DSeq_List[$j]=substr($DSeq_List[$j], 0, 4);
              if ($Dup_evt[$DSeq_List[$j]] ne "Y") {
                $report_SFP[$i] = "NO, this Event Eliminated by another Event";
                if (($evt_endpt_elim_by[$i] eq "") && ($j==1)){
                  print "$seq_num $evt_LogTimeStamp[$i]  $evt_LogId[$i]  $short_configDesc n     $DSeq_List[$j]  na          n\n";
                } else  { 
                  print "                                                             $DSeq_List[$j]\n";
                }  
              }
            }
          }
        }
      }
    }
  }

  if ($evt_LogId[$i] =~ /BC60/) {
    print "                          $evt_SRN[$i]\n";
  }
  #-----------------------------------------------------------------
  # Write out Location for each Event that needs Sevice.
  #-----------------------------------------------------------------
  if ($SVC eq "Y") {
    $DeviceLoc=getDeviceLoc($i); 
    @Endpt_List=split(/,/ ,$evt_DevEndptLocs[$i]);
    getEndptLoc();
    @Riser_List=split(/,/ ,$evt_DevRiserLocs[$i]);
    getRiserLoc();
    $FrameCage=substr($DeviceLoc, 0, 11);
    # print "                                                                   $FrameCage\n";
    if ($displaylocs eq "Y") {
      print "                    .........................................................\n";
      print "                    Frame  Cage  CageType  DevType  Card/Book  Chip/Adpt Port\n";
      print "       Device:      $DeviceLoc\n";
      if (($evt_DevEndptLocs[$i] ne "") && ($evt_DevEndptLocs[$i] ne "000000000000000")) {
        for ($j = 0; $j <= $#Endpt_List; $j++) {
          if ($j == 0) {
            print "       Endpts:      $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";
            print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]\n";
          } else {                        
            print "                    $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";
            print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]\n";
          }
        } 
      } 
      if (($evt_DevRiserLocs[$i] ne "") && ($evt_DevRiserLocs[$i] ne "000000000000000")) {
        for ($j = 0; $j <= $#Riser_List; $j++) {
          if ($j == 0) {
            print "       Risers:      $Riser_Frame[$j] $Riser_Cage[$j] $Riser_CageType[$j]";
            print " $Riser_DevType[$j] $Riser_Card[$j] $Riser_Chip[$j] $Riser_Port[$j]\n";
          } else {
            print "                    $Riser_Frame[$j] $Riser_Cage[$j] $Riser_CageType[$j]";
            print " $Riser_DevType[$j] $Riser_Card[$j] $Riser_Chip[$j] $Riser_Port[$j]\n";
          }
        }
      } 
      if ($evt_LogId[$i] =~ /BC60/) {
        print "                    Full FRU location MUST be decoded from Refcode $evt_SRN[$i]\n";
      }
      print "                    .........................................................\n";
    }                              
  }

  if ($i == $evt_LIP[$pool_num]) {
    if ($i == $evtnum) {
      print "\n"; 
      print "================================================================================\n";       
      print "\n"; 
      print "SECTION1:           E N D     E V E N T    S U M M A R Y                     \n";
      print "\n"; 
      print "================================================================================\n";       
      print "................................................................................\n";       
      print "................................................................................\n";       
      print "................................................................................\n";       
      print "................................................................................\n";       
      print "................................................................................\n";       
    } else {
      $pool_num++;
      print "\n"; 
      print "================================================================================\n";
      print "                          ELA  Pool_$pool_num  Events($evt_FIP[$pool_num]-$evt_LIP[$pool_num])\n";    
      print "================================================================================\n";
    }
  }
}

#-------------------------------------------------------------------
# Write Section2 Detailed Data Report 
#-------------------------------------------------------------------
$LOCATION_HDR="                Frame  Cage  CageType  DevType  Card/Book  Chip/Adpt Port\n";
$pool_num=1;
print "================================================================================\n";
print "\n"; 
print "SECTION2:           S T A R T    E V E N T    D E T A I L S                     \n"; 
print "\n"; 
for ($i = 1; $i <= $evtnum; $i++) {
  #-----------------------------------------------------------------
  # Parse EventId Fields Type and Class
  #-----------------------------------------------------------------
  $evt_Type=substr($evt_LogId[$i],2,1);
  $evt_Class=substr($evt_LogId[$i],0,2);

  $action="- If this Reference Code has NOT been reported to SFP\n";

  if ( $evt_Class eq "BC" ) {
    $label = "POWER_SUBSYSTEM_ERR";
    $rep_Comp="Environmental Logger";
  } 

  if ( $evt_Class eq "BB" ) {
    if ( $evt_Type eq "1" ) {      
      $label = "SWITCH_DEVICE_ERR";
      $rep_Comp="FNM Recovery";
    }
    if ( $evt_Type eq "2" ) {      
      $label = "SWITCH_LINK_ERR";
      $rep_Comp="FNM Recovery";
    }
    if ( $evt_Type eq "3" ) {      
      $label = "ADAPTER_DEVICE_ERR";
      $rep_Comp="FNM Recovery";
    }
    if ( $evt_Type eq "4" ) {      
      $label = "ADAPTER_LINK_ERR";
      $rep_Comp="FNM Recovery";
    }
    if ( $evt_Type eq "5" ) {      
      $label = "RISER_DEV_ERR";
      $rep_Comp="FNM Initialization";
    }
    if ( $evt_Type eq "6" ) {                          
      $label = "ALERT_ERR";
      if ($evt_LogId[$i] =~ /BB6000[125E]./) {
        $rep_Comp="FNM Recovery";
        $action="ELA does not report THIS Event to SFP. AIX is responsable. 
        Used for elimination of other Events in this Pool ONLY\n";
      }
      if (($evt_LogId[$i] =~ /BB600060/) || ($evt_LogId[$i] =~ /BB600510/)) {
        $rep_Comp="FNM Initialization";
        $action="ELA does not report THIS Event to SFP. Link status change. 
        Used for elimination of other Events in this Pool ONLY\n";
      }
      if ($evt_LogId[$i] =~ /BB60F0F[2BC]/) {
        $rep_Comp="FNM Initialization";
        $action="ELA does not report THIS Event to SFP. Intentional action. 
        Used for elimination of other Events in this Pool ONLY\n";
      }
    }

    if ($evt_LogId[$i] =~ /BB[123578]0F0F[012345789ADEF]/) {      
      $rep_Comp="FNM Initialization";
    } 

    if ($evt_LogId[$i] =~ /BB[12345]0F[123]0[1234]/) {
      $rep_Comp="Diagnostic Tests";
    }
  }
  if (($evt_endpt_elim_by[$i] ne "") || ($evt_device_elim_by[$i] ne "")) {
    $action="This Event has been eliminated by another Event\n";
  }

  #-----------------------------------------------------------------
  # Set ALL Locations assocaiated with Error EventId 
  #-----------------------------------------------------------------
  # Location of Devive in Error
  #-----------------------------------------------------------------
  $DeviceLoc=getDeviceLoc($i);

  #-----------------------------------------------------------------
  # Location of Endpt Devices Connectioned to the Devive in Error
  #-----------------------------------------------------------------
  @Endpt_List=split(/,/ ,$evt_DevEndptLocs[$i]);
  getEndptLoc();               

  #-----------------------------------------------------------------
  # Location of Riser Endpt Devices Connectioned to the Devive in Error
  #-----------------------------------------------------------------
  @Riser_List=split(/,/ ,$evt_DevRiserLocs[$i]);
  getRiserLoc();               

  #-----------------------------------------------------------------
  # Write out System Error Log
  #-----------------------------------------------------------------
  if ($i == $evt_FIP[$pool_num]) {
    print "================================================================================\n";       
    print "                          Start  ELA  Pool_$pool_num  Events($evt_FIP[$pool_num]-$evt_LIP[$pool_num])\n";
    print "================================================================================\n";       
  } else {
    if ($Dup_evt[$i] ne "Y") {
      print "\n";
      print "________________________________________________________________________________\n";
    }
  }
  if ($Dup_evt[$i] ne "Y") {
    print "LABEL:                     $label\n";
    print "EVENT ID:                  $evt_LogId[$i]\n";
    if ( $evt_Class eq "BC" ) {
      print "REFERENCE CODE:            $evt_SRN[$i]\n";
    } else {
      print "REFERENCE CODE:            $evt_LogId[$i]\n";
    }
    print "\n";

    print "Seq Number  Date/Time:     $seq_tds[$i]";
    print "Reporting Component:       $rep_Comp\n";
    print "\n";

    print "ELA should Report to SFP:  $report_SFP[$i]\n";  
    print "ELA Pool Timeout:          $config_Timeout[$i] seconds  Pool $pool_num\n";
    print "\n";

    print "Description\n";
    print "        $config_Desc[$i]\n";
    print "\n";

    if ( $evt_Class eq "BC" ) {
      print "Logical Device in Error Elimination Location\n";
      print "$LOCATION_HDR";
      print "        Device: $DeviceLoc\n";
      print "        *Note: Error Location decoded by ELA from Reference Code\n";
    } else {
      print "Logical Device in Error Locations\n";
      print "$LOCATION_HDR";
      print "        Device: $DeviceLoc\n";
      if ($WarnMsg1 ne "") {
        print "$WarnMsg1\n";
      }
    }
    if (($evt_DevEndptLocs[$i] ne "") && ($evt_DevEndptLocs[$i] ne "000000000000000")) {
      for ($j = 0; $j <= $#Endpt_List; $j++) {
        if ($j == 0) {
          print "        Endpts: $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";   
          print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]\n";
        } else {
          print "                $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";
          print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]\n";
        }
      }
    }
    if (($evt_DevRiserLocs[$i] ne "") && ($evt_DevRiserLocs[$i] ne "000000000000000")) {
      for ($j = 0; $j <= $#Riser_List; $j++) {
        if ($j == 0) {
          print "        Risers: $Riser_Frame[$j] $Riser_Cage[$j] $Riser_CageType[$j]";                 
          print " $Riser_DevType[$j] $Riser_Card[$j] $Riser_Chip[$j] $Riser_Port[$j]\n";
        } else {
          print "                $Riser_Frame[$j] $Riser_Cage[$j] $Riser_CageType[$j]";
          print " $Riser_DevType[$j] $Riser_Card[$j] $Riser_Chip[$j] $Riser_Port[$j]\n";
        }
      }
    }

    print "\n";
    print "Recommended Actions\n";

    if ($report_SFP[$i] =~ /NO/) {
        print "        $action";
        print "           > No Service action required\n";
    }
    if ($report_SFP[$i] eq "NO, this Event Eliminated by another Event") {
    }
    if ($report_SFP[$i] eq "NO, this Event ONLY used to Eliminate other Events") {
    }
    if ($report_SFP[$i] eq "NO, this Event is a Duplicate of an earlier Event") {
    }

    if ($report_SFP[$i] =~ /YES/) {
      print "        - Review Service Focal Point for the following Reference Code\n";
      if ($evt_used_in_NE[$i] eq "N") {
        print "           > THIS Event's Reference Code\n";
        $FRU_rem=$config_FRU_list[$i];
        $FRU_len=-1;
        do {
          $FRU_rem = substr($FRU_rem, $FRU_len+1, length($FRU_rem));
          if ( length($FRU_rem) > 50 ) {
            $last_blank=rindex($FRU_rem," ",50);
            $last_comma=rindex($FRU_rem,",",50);
            if ( $last_blank > $last_comma ) { $FRU_len=$last_blank; }
              else { $FRU_len=$last_comma; }
          } else {
            $FRU_len=length($FRU_rem); 
          }
          $FRU_str = substr($FRU_rem, 0, $FRU_len+1);
          if ( length($FRU_rem) == length($config_FRU_list[$i]) ) {
            print "                  $evt_SRN[$i] <!--  Full Description Above  -->\n";
            print "                  FRU LIST $FRU_str\n"; 
          } else {
            print "                           $FRU_str\n"; 
          }  
        } while ( length($FRU_rem) > 50 );
      } else {
        print "           > NEW  Event Reference Code (combined with THIS and other Events)\n";
        # $config_AssociatedNewevents[$i] =~ s/ *//g;
        # $config_AssociatedNewevents[$i] =~ s/\{//g;
        # $config_AssociatedNewevents[$i] =~ s/\}//g;
        # @AE_evt_LogId=split(/,/ ,$config_AssociatedNewevents[$i]);
        $NE_evtId = substr($evt_used_in_NE[$i], 0, 8);
        $NE_set   = substr($evt_used_in_NE[$i], 9, 3);
        @AE_evt_LogId=split(/,/ ,$NE_evtId);
        if ($#AE_evt_LogId >= 0) {
          getAE_ConfigData();
          for ($j = 0; $j <= $#AE_evt_LogId; $j++) {
            $AE_config_Desc[$j] =~ s/.//;
            print "                  $AE_evt_LogId[$j] $AE_config_Desc[$j]\n";   
            # $AE_Expand=getAE_Expanded($AE_evt_LogId[$j]);
            # print "                         $AE_Expand\n";
            $FRU_rem=$AE_config_FRU_list[$j];
            $FRU_len=-1;
            $cnt=0;
            do {
              $cnt++;
              $FRU_rem = substr($FRU_rem, $FRU_len+1, length($FRU_rem));
              if ( length($FRU_rem) > 50 ) {
                $last_blank=rindex($FRU_rem," ",50);
                $last_comma=rindex($FRU_rem,",",50);
                if ( $last_blank > $last_comma ) { $FRU_len=$last_blank; }
                else { $FRU_len=$last_comma; }
              } else {
                $FRU_len=length($FRU_rem); 
              }
              $FRU_str = substr($FRU_rem, 0, $FRU_len+1);
              if ($cnt == 1) { 
                print "                  SET NUM  {$NE_set} $evt_used_in_NE[$i] Set details at end of this Pool\n";   
                print "                  FRU LIST $FRU_str\n"; 
              } else {
                print "                           $FRU_str\n"; 
              }
            } while ( length($FRU_rem) > 50 );
          }
        } 
      }
      print "\n";
      print "        $action";
      print "           > Apply the FRU LIST actions stated above\n";
      print "           > Contact appropriate Service Representative\n";
      print "             Supply FNM snap from Master and Backup HMCs\n";
    }
    print "\n";

    print "ELIMINATION DETAILS\n";
    print "-------------------\n";
    if ( ( $evt_Type eq "6" ) || ($evt_LogId[$i] =~ /BB[12345]0F[123]0[1234]/)) {
      if ($evt_LogId[$i] =~ /BB60/) {
        print "        - None. Alert Events may NOT be eliminated\n";
      }
      if ($evt_LogId[$i] =~ /BC60/) {
        print "        - None. Power Subsystem Events may NOT be eliminated\n";
      }
      if ($evt_LogId[$i] =~ /BB[12345]0F[123]0[1234]/) {
        print "        - None. Diagnostic Events may NOT be eliminated\n";
      }
    } else {
      if ($Hot_evt_threshold[$i] eq "Y") {
        print "!!!!!! WARNING---> THIS Event has met HOT threshold of <14> and CANNOT\n";
        print "                   be eliminated by another Event                     \n\n";
      }
      if ($evt_endpt_elim_by[$i] ne "") {
        print "Eliminate --------> THIS Event if it's Endpt is Located on Device Event<Level>\n";
        print "                    Frame  Cage  CageType  DevType  Card/Book  Chip/Adpt Port\n";
        for ($j = 0; $j <= $#Endpt_List; $j++) {
          if ($j == 0) {
            print "        - ThisEndpt $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";
            print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]";
          } else { 
            print "                    $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";
            print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]";
          }
        }
        print "                         $evt_endpt_elim_by[$i]\n";
      } else {
        print "Eliminate --------> THIS Event if it's Endpt is Located on Device Event<Level>\n";
        if ($Hot_evt_threshold[$i] eq "Y") {
          print "        - NA\n";
        } else {
          print "        - None\n";
        }
      }
      print "\n";

      if ($evt_device_elim_by[$i] ne "") {
        print"Eliminate --------> THIS Event if it's Device is Located on Device Event<Level>\n";
        print "                    Frame  Cage  CageType  DevType  Card/Book  Chip/Adpt Port\n";
        print "        - ThisDev   $DeviceLoc";   
        print "                         $evt_device_elim_by[$i]\n";
      } else {
        print"Eliminate --------> THIS Event if it's Device is Located on Device Event<Level>\n";
        if ($Hot_evt_threshold[$i] eq "Y") {
          print "        - NA\n";
        } else {
          print "        - None\n";
        }
      }
    }
  }

  if ($i == $evt_LIP[$pool_num]) {
    print "\n";
    print "================================================================================\n";       
    print "                          End  ELA  Pool_$pool_num Events($evt_FIP[$pool_num]-$evt_LIP[$pool_num])\n";
    print "NEW EVENT DETAILS \n";
    print "-------------------\n";
    $unique_NE_Str = "";
    #-----------------------------------------------------------------
    # Create a List of unique event sets in the pool
    #-----------------------------------------------------------------
    for ($k = $evt_FIP[$pool_num]; $k <= $evt_LIP[$pool_num]; $k++) {
      if ( ($unique_NE_Str !~/$evt_used_in_NE[$k]/) && ($evt_used_in_NE[$k] ne "N") ) { 
        $unique_NE_Str = "$unique_NE_Str,$evt_used_in_NE[$k]";
      }
    } 
    # print "unique_NE_Str=$unique_NE_Str\n";
    @unique_NE = split(/,/ ,$unique_NE_Str);
    if ($#unique_NE >= 0) {
      $sort_unique_NE_Str = "";
      #-----------------------------------------------------------------
      #  Sort the List of unique event sets in the pool
      #-----------------------------------------------------------------
      for ($l = 1; $l <= $#unique_NE; $l++) {
        if (($sort_unique_NE_Str !~ /$unique_NE[$l]/) && ($unique_NE[$l] ne "Used")) {
          $sort_unique_NE_Str = "$sort_unique_NE_Str,$unique_NE[$l]";
          $unique_NE[$l] = "Used";
          for ($m = $l+1; $m <= $#unique_NE; $m++) {
            $short_unique_NE = substr($unique_NE[$m], 0, 8);
            if ($sort_unique_NE_Str =~ /$short_unique_NE/) {  
              $sort_unique_NE_Str = "$sort_unique_NE_Str,$unique_NE[$m]";
              $unique_NE[$m] = "Used";
            }
          }
        }
      }
      # print "sort_unique_NE_Str=$sort_unique_NE_Str\n";
      @sort_unique_NE = split(/,/ ,$sort_unique_NE_Str);
      #-----------------------------------------------------------------
      # Create a List of unique event sets in the pool
      #-----------------------------------------------------------------
      $last_sort_unique_NE = "FISRT";
      for ($l = 1; $l <= $#sort_unique_NE; $l++) {
        if ($sort_unique_NE[$l] !~ /$last_sort_unique_NE/) {
          $short_sort_unique_NE = substr($sort_unique_NE[$l], 0, 8);
          @NE_evtinfo = split(/:/ ,getAE_Expanded($short_sort_unique_NE));
          $NE_descr  = $NE_evtinfo[2];
          if ($l != 1) {
            print "\n";
          }
          print "$short_sort_unique_NE ---------> $NE_descr\n";                             
        }
        print "    $sort_unique_NE[$l]\n";
        print "                     Frame  Cage  CageType  DevType  Card/Book  Chip/Adpt Port\n";
        for ($k = $evt_FIP[$pool_num]; $k <= $evt_LIP[$pool_num]; $k++) {
          $DeviceLoc=getDeviceLoc($k);
          @Endpt_List=split(/,/ ,$evt_DevEndptLocs[$k]);
          getEndptLoc();
          $DeviceLocHdr="        - $k<Dev>       "; 
          $DeviceLocHdr=substr($DeviceLocHdr,0,21);
          if ($sort_unique_NE[$l] eq $evt_used_in_NE[$k]) {
            if ($evt_used_in_NE_loctype[$k] eq "Dev") {
              print "$DeviceLocHdr$DeviceLoc\n";
            } else {
              if (($evt_DevEndptLocs[$k] ne "") && ($evt_DevEndptLocs[$k] ne "000000000000000")) {
                for ($j = 0; $j <= $#Endpt_List; $j++) {
                  # print "$k  #Endpt_List=$#Endpt_List evt_DevEndptLocs[$k]= $evt_DevEndptLocs[$k]\n";
                  $EndptLocHdr="        - $k<Endpt>       "; 
                  $EndptLocHdr=substr($EndptLocHdr,0,21);
                  if ($j == 0) {
                    print "$EndptLocHdr$Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";   
                    print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]\n";
                  } else {
                    print "                    $Endpt_Frame[$j] $Endpt_Cage[$j] $Endpt_CageType[$j]";
                    print " $Endpt_DevType[$j] $Endpt_Card[$j] $Endpt_Chip[$j] $Endpt_Port[$j]\n";
                  }
                }
              }
            }
          }
        }
        $last_sort_unique_NE = substr($sort_unique_NE[$l], 0, 8);
      }
    } else {
      print "        - None\n";
    }

    print "\n";
    print "================================================================================\n";       
    print "\n";
    print "\n";
    $pool_num++;
  } 
}

print "================================================================================\n";       
print "\n";
print "SECTION2:           E N D    E V E N T    D E T A I L S                         \n";
print "\n";
print "================================================================================\n";       
print "................................................................................\n";       
print "................................................................................\n";       
print "................................................................................\n";       
print "................................................................................\n";       
print "................................................................................\n";       

#-------------------------------------------------------------------
# Supress SFP Report
#-------------------------------------------------------------------
if ($supressSFP eq "Y") {
  exit;
}          

#-------------------------------------------------------------------
# Write Section3 SFP Output Report 
# lsrsrc -s "Status='Open' &Nodes[0].ErrorClass='HMC'" IBM.ServiceEvent
#-------------------------------------------------------------------
print "================================================================================\n";       
print "\n";
print "SECTION3:           S T A R T    S F P    O P E N    H M C    E V E N T S       \n"; 
print "\n";
print "================================================================================\n";       
open(FH, "lsrsrc -s \"Status='Open' &Nodes\[0\]\.ErrorClass=\'HMC\'\" IBM.ServiceEvent  | ") or die("Failed to open lsrsrc.");
while(<FH>)
{
  chomp;
  $SFP_rem = $_;
  $SFP_len=-1;
  do {
    $SFP_rem = substr($SFP_rem, $SFP_len+1, length($SFP_rem));
    if ( length($SFP_rem) > 51 ) {
      $last_blank=rindex($SFP_rem," ",51);
      $last_comma=rindex($SFP_rem,",",51);
      $last_slash=rindex($SFP_rem,"/",51);
      if ( $last_slash > -1 ) { $SFP_len=$last_slash; }
      if (( $last_blank > -1 ) && ($last_slash <= $last_blank)) { $SFP_len=$last_blank; }
      if (( $last_comma > -1 ) && (($last_blank <= $last_comma) && ($last_slash <= $last_comma))){ $SFP_len=$last_comma; }
     } else {
       $SFP_len=length($SFP_rem);
     }
     $SFP_str = substr($SFP_rem, 0, $SFP_len+1);
     if (($SFP_str =~ /^\t.+=/) || ($SFP_str =~ /^(resource \d+:)/)) {
       print "$SFP_str\n";
     } else { 
       print "                            $SFP_str\n";
     }
     if ($SFP_str =~ /^(resource \d+:)/) {
       print "--------------------------------------------------------------------------------\n";
     }
  } while ( length($SFP_rem) > 51 );
}
print "\n";
print "================================================================================\n";
print "\n";
print "SECTION3:           E N D    S F P    O P E N     H M C    E V E N T S          \n"; 
print "\n";
print "================================================================================\n";



####################################################################
#
# SUBROUTINES
#
####################################################################
#-------------------------------------------------------------------
# Read the Event Summary Log and set all ELA data assocaited with 
# reported Error EventIds.
#-------------------------------------------------------------------
sub getSummaryLogData {
 open F1,$EVENT_LOG_SUMMARY_FILE or die "Can't open $EVENT_LOG_SUMMARY_FILE : $!";
 $f=0;
 while ( <F1> ) {       
   chomp;
   if ($_ =~ /TimeStamp=/) {
     $last_mandatory_fields=0;
     $eq_pos=index($_,"=",0);
     $colin_pos=index($_,":",0);

     $sav_LogTimeStamp=substr($_, $eq_pos+1, length($_));
     $sav_LogTimeStamp_epoch=epochTime($sav_LogTimeStamp);

     $f++;
     # print "\n$f 1st While Timestamp Found> $_ \n";
     while ( <F1> ) {       
       chomp;
       # print "2nd While Chop next> $_ \n";

       last if ($last_mandatory_fields==1) && 
               (($_ !~ /refcodeExt_endptDevs=/) && ($_ !~ /refcodeExt_riserDevs=/));
       last if ($sav_LogTimeStamp_epoch < $cutoff_epoch); 
       # Informational HW Events not handled by ELA 
       last if (($_ =~ /EventId=BB600030/) || ($_ =~ /EventId=BB6000FF/));
       last if (($_ =~ /EventId=BB306010/) || ($_ =~ /EventId=BB306012/));
       last if (($_ =~ /EventId=BB200608/) || ($_ =~ /EventId=BB20060F/));
       # Software Events not handled by ELA
       last if ($_ =~ /EventId=BD/);

       $eq_pos=index($_,"=",0);
       $colin_pos=index($_,":",0);

       if ($_ =~ /EventId=B[BC]/) {
         $evtnum++;
         $evt_LogTimeStamp[$evtnum]=$sav_LogTimeStamp;
         $evt_LogId[$evtnum]=substr($_, $eq_pos+1, length($_));
         # print "Pick Event $eventnum\n";
       } 

       if ($_ =~ /Refcode=/) {
         $evt_SRN[$evtnum]=substr($_, $eq_pos+1, length($_));
       }  

       if ($_ =~ /RefcodeExt=/) {
         $evt_DevLoc[$evtnum] = substr($_, $eq_pos+1, length($_));
         $evt_DevLoc[$evtnum] =~ tr/\t //d;
         $evt_DevLoc[$evtnum] =~ tr/ABCDEF/abcdef/;
         # print "before evt_DevLoc[$evtnum]=  $evt_DevLoc[$evtnum]\n";
         $pad=substr("0000000000000000", 1, 16-length($evt_DevLoc[$evtnum]));
         $evt_DevLoc[$evtnum]=  "$pad$evt_DevLoc[$evtnum]";
         $last_mandatory_fields=1;
         # print "after evt_DevLoc[$evtnum]=   $evt_DevLoc[$evtnum]\n \n";
         $evt_Type=substr($evt_LogId[$i],2,1);
         if ( ((substr($evt_LogId[$evtnum],2,1) == 1) || (substr($evt_LogId[$evtnum],2,1) == 2)) && (substr($evt_DevLoc[$evtnum],13,1) != 1) ) {
           $evt_DevLocBegin=substr($evt_DevLoc[$evtnum],0,13);
           $evt_DevLocEnd  =substr($evt_DevLoc[$evtnum],14,3);
           $swtcard="1";
           # print "before evt_DevLoc[$evtnum]=  $evt_DevLoc[$evtnum]\n";
           $evt_DevLoc[$evtnum] = "$evt_DevLocBegin$swtcard$evt_DevLocEnd";
           # print "   << Bad Card number Location Corrected on Event seq# $evtnum >>\n";
           # print "after evt_DevLoc[$evtnum]=   $evt_DevLoc[$evtnum]\n \n";
         }
       }  
       
       if ($_ =~ /refcodeExt_endptDevs=/) {
         $evt_DevEndptLocs[$evtnum]=substr($_, $eq_pos+1, length($_));
         $evt_DevEndptLocs[$evtnum] =~ tr/\t //d;
         $evt_DevEndptLocs[$evtnum] =~ tr/ABCDEF/abcdef/;
         # print "before evt_DevEndptLocs[$evtnum]= $evt_DevEndptLocs[$evtnum]\n";
         @Endpt_List=split(/,/ ,$evt_DevEndptLocs[$evtnum]);
         if ($#Endpt_List >= 0) {
           for ($i = 0; $i <= $#Endpt_List; $i++) {
             $evt_DevEndptLocs[$evtnum]=$Sav_evt_DevEndptLocs;
             $pad=substr("0000000000000000", 1, 16-length($Endpt_List[$i]));
             if ($i == 0) {
               $Sav_evt_DevEndptLocs=  "$pad$Endpt_List[$i]";
             } else { 
               $Sav_evt_DevEndptLocs=  "$Sav_evt_DevEndptLocs,$pad$Endpt_List[$i]";
             }
           } 
           $evt_DevEndptLocs[$evtnum]=$Sav_evt_DevEndptLocs;
         }
         # print "after evt_DevEndptLocs[$evtnum]=  $evt_DevEndptLocs[$evtnum]\n \n";
       }  
       
       if ($_ =~ /refcodeExt_riserDevs=/) {
         $evt_DevRiserLocs[$evtnum]=substr($_, $eq_pos+1, length($_));
         $evt_DevRiserLocs[$evtnum] =~ tr/\t //d;
         $evt_DevRiserLocs[$evtnum] =~ tr/ABCDEF/abcdef/;
         # print "before evt_DevRiserLocs[$evtnum]=  $evt_DevRiserLocs[$evtnum]\n";
         @Riser_List=split(/,/ ,$evt_DevRiserLocs[$evtnum]);
         if ($#Endpt_List >= 0) {
           for ($i = 0; $i <= $#Riser_List; $i++) {
             $pad=substr("0000000000000000", 1, 16-length($Riser_List[$i]));
             if ($i == 0) {
               $Sav_evt_DevRiserLocs=  "$pad$Riser_List[$i]";
             } else {
               $Sav_evt_DevRiserLocs=  "$Sav_evt_DevRiserLocs,$pad$Riser_List[$i]";
             }
           }
           $evt_DevRiserLocs[$evtnum]=$Sav_evt_DevRiserLocs;
         }
         # print "after evt_DevRiserLocs[$evtnum]=   $evt_DevRiserLocs[$evtnum]\n \n";
       }
     } 
   } 
 } 
 close F1;
}

#-------------------------------------------------------------------
# Read the ELA configuration file and set all data fields associated
# with EventIds from Event Summary Log.
#-------------------------------------------------------------------
sub getConfigData {
 for ($i = 1; $i <= $evtnum; $i++) {
   $evt_found=0; 
   open F1,$ELA_CONFIG_FILE or die "Can't open $ELA_CONFIG_FILE : $!";
   while ( <F1> ) {
     chomp;
     if ( $_ =~ /<!--/ ) {
       $last_config_comment=$_
     }
     if ( $_ =~ /EventId-/ ) {
       last if $evt_found==1;
       $dash_pos=index($_,"-",0);
       $config_EvtId=substr($_, $dash_pos+1, 8);
       if ( $config_EvtId eq $evt_LogId[$i] ) {
         if ($config_EvtId eq "BB600510") {
           $config_Desc[$i]="        <!--  (Link Up[16]) Switch Link Up received  -->"
         } else {
           $config_Desc[$i]=$last_config_comment;
         }
         $config_Desc[$i] =~ s/.*</</g;
         $evt_found=1;
         # print "FOUND>>> $i log_EvtId=$evt_LogId[$i] config_evtid=$config_EvtId\n";
       }
     } else {
       if ( $evt_found==1 ) {
         $first_gt=index($_,">",0); 
         $last_lt=index($_,"<",$first_gt); 

         if ( $_ =~ /<key name="elimination_level">/ )  {
           $config_EliminationLevel[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
         }

         if ( $_ =~ /<key name="priority">/ )  {
           $config_Priority[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
         }

         if ( $_ =~ /<key name="timeout">/ )  {
           $config_Timeout[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           if ($global_timeout > 0) {
             $config_Timeout[$i]=$global_timeout;
           }
         }
         $Dup_evt_num[$i]=1;
         $Dup_evt[$i]="N";
         $Hot_evt_threshold[$i]="N";
         $evt_eliminated[$i]="N";
         $evt_used_in_NE[$i]="N";
         $evt_used_in_NE_loctype[$i]="";

         if ( $_ =~ /<key name="threshold">/ )  {
           $config_HotThreshold[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           if ($config_HotThreshold[$i] !~ /\d/) {
             $config_HotThreshold[$i]=100000000;
           }
         }

         if ($_ =~ /<key name="FRU_list">/ )  {
           if ( $last_lt == -1 ) {
             $config_FRU_list[$i]=substr($_, $first_gt+1, length($_));
             while ( <F1> ) {
               chomp;
               $last_lt=index($_,"<",1);
               if ( $last_lt == -1 ) {
                 $config_FRU_list[$i]="$config_FRU_list[$i] \n $_";
               } else {
                 $config_FRU_list_endstr=substr($_, 0, $last_lt);
                 $config_FRU_list[$i]="$config_FRU_list[$i] \n $config_FRU_list_endstr";
               }
               last if $last_lt != -1;
             }
           } else {
              $config_FRU_list[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           }
         }

         if ($_ =~ /<key name="EP_affectedIDs">/ ) {
           if ( $last_lt == -1 ) {
             $config_EP_affectedIDs[$i]=substr($_, $first_gt+1, length($_));
             while ( <F1> ) {
               chomp;
               $last_lt=index($_,"<",1);
               if ( $last_lt == -1 ) {
                 $config_EP_affectedIDs[$i]="$config_EP_affectedIDs[$i] $_";
               } else {
                 $config_EP_affectedIDs_endstr=substr($_, 0, $last_lt);
                 $config_EP_affectedIDs[$i]="$config_EP_affectedIDs[$i] $config_EP_affectedIDs_endstr";
               }
               last if $last_lt != -1;
             }
           } else {
             $config_EP_affectedIDs[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           }
         }
 
         if ($_ =~ /<key name="LD_affectedIDs">/ ) {
           if ( $last_lt == -1 ) {
             $config_LD_affectedIDs[$i]=substr($_, $first_gt+1, length($_));
             while ( <F1> ) {
               chomp;
               $last_lt=index($_,"<",1);
               if ( $last_lt == -1 ) {
                 $config_LD_affectedIDs[$i]="$config_LD_affectedIDs[$i] $_";
               } else {
                 $config_LD_affectedIDs_endstr=substr($_, 0, $last_lt);
                 $config_LD_affectedIDs[$i]="$config_LD_affectedIDs[$i] $config_LD_affectedIDs_endstr";
               }
               last if $last_lt != -1;
             }
           } else {
              $config_LD_affectedIDs[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           }
         }

         if ($_ =~ /<key name="associated_newevents">/ ) {
           if ( $last_lt == -1 ) {
             $config_AssociatedNewevents[$i]=substr($_, $first_gt+1, length($_));
             while ( <F1> ) {
               chomp;
               $last_lt=index($_,"<",1);
               if ( $last_lt == -1 ) {
                 $config_AssociatedNewevents[$i]="$config_AssociatedNewevents[$i] $_";
               } else {
                 $config_AssociatedNewevents_endstr=substr($_, 0, $last_lt);
                 $config_AssociatedNewevents[$i]="$config_AssociatedNewevents[$i] $config_AssociatedNewevents_endstr";
               }
               last if $last_lt != -1;
             }
           } else {
              $config_AssociatedNewevents[$i]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           }
         }
       } 
     }
   }
   close F1;
 }
}

#-------------------------------------------------------------------
# Read the ELA configuration file and set all data fields associated
# with Associated EventIds belonging to the EventIds from Event 
# Summary Log.
# Input:  global $AE_evt_LogId Array
# Output: global $AE_config_Desc, $AE_config_FRU_list and 
#         $AE_config_Priority for $AE_evt_LogId
#-------------------------------------------------------------------
sub getAE_ConfigData {
 for ($k = 0; $k <= $#AE_evt_LogId; $k++) {
   $evt_found=0; 
   open F1,$ELA_CONFIG_FILE or die "Can't open $ELA_CONFIG_FILE : $!";
   while ( <F1> ) {
     chomp;
     if ( $_ =~ /<!--/ ) {
       $last_config_comment=$_
     }
     if ( $_ =~ /EventId-/ ) {
       last if $evt_found==1;
       $dash_pos=index($_,"-",0);
       $config_EvtId=substr($_, $dash_pos+1, 8);
       # print "config_EvtId= $config_EvtId eq AE_evt_LogId[$k]= $AE_evt_LogId[$k] eq\n";
       if ( $config_EvtId eq $AE_evt_LogId[$k] ) {
         $AE_config_Desc[$k]=$last_config_comment;
         $evt_found=1;
         # print "FOUND>>> $k log_EvtId=$AE_evt_LogId[$k] config_evtid=$config_EvtId\n";
       }
     } else {
       if ( $evt_found==1 ) {
         $first_gt=index($_,">",0); 
         $last_lt=index($_,"<",$first_gt); 

         if ( $_ =~ /<key name="priority">/ )  {
           $AE_config_Priority[$k]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
         }

         if ($_ =~ /<key name="FRU_list">/ )  {
           if ( $last_lt == -1 ) {
             $AE_config_FRU_list[$k]=substr($_, $first_gt+1, length($_));
             while ( <F1> ) {
               chomp;
               $last_lt=index($_,"<",1);
               if ( $last_lt == -1 ) {
                 $AE_config_FRU_list[$k]="AE_$config_FRU_list[$k] \n $_";
               } else {
                 $AE_config_FRU_list_endstr=substr($_, 0, $last_lt);
                 $AE_config_FRU_list[$k]="$config_FRU_list[$k] \n $config_FRU_list_endstr";
               }
               last if $last_lt != -1;
             }
           } else {
              $AE_config_FRU_list[$k]=substr($_, $first_gt+1, ($last_lt-$first_gt)-1);
           }
         }
       } 
     }
   }
   close F1;
 }
}

#-------------------------------------------------------------------
# Get Device location 
# Input:   Event index used to access  Event's Hex Device Location
# Returns: Decimal Device location formated string.
#-------------------------------------------------------------------
sub getDeviceLoc {
  my ($x) = @_;

  $Frame=        hex(substr($evt_DevLoc[$x], 6,3));
  $pad=          substr("      ", 1, 6-length($Frame));
  $Frame=        "$Frame$pad";

  $Cage=         hex(substr($evt_DevLoc[$x],9,2)); 
  $pad=          substr("     ", 1, 5-length($Cage));
  $Cage=         "$Cage$pad";

  $CageType=     hex(substr($evt_DevLoc[$x],11,1)); 
  if ($CageType eq "0") { $CageType="SWT"; }
  if ($CageType eq "1") { $CageType="CEC"; }
  if ($CageType eq "2") { $CageType="BPA"; }
  $pad=          substr("         ", 1, 9-length($CageType));
  $CageType=     "$CageType$pad";

  $DevType=      hex(substr($evt_DevLoc[$x],12,1)); 
  if ($DevType eq "2") { $DevType="Adapter"; }
  if ($DevType eq "3") { $DevType="Switch"; }
  if ($DevType eq "4") { $DevType="Riser"; }
  $pad=          substr("        ", 1, 8-length($DevType));
  $DevType=      "$DevType$pad";

  $Card=         hex(substr($evt_DevLoc[$x],13,1)); 
  $pad=          substr("          ", 1, 10-length($Card));
  $Card=         "$Card$pad";

  $Chip=         hex(substr($evt_DevLoc[$x],14,1));
  $pad=          substr("         ", 1, 9-length($Chip));
  $Chip=         "$Chip$pad";

  $Port=         hex(substr($evt_DevLoc[$x],15,1));
  $pad=          substr("        ", 1, 8-length($Port));
  $Port=         "$Port";
  if ( $evt_Class eq "BC" ) {
    if (($config_EliminationLevel[$x] eq "FRAME") || ($config_EliminationLevel[$x] eq "CAGE")){
      $device_loc="$Frame $Cage $CageType";
    } 
    if ($config_EliminationLevel[$x] eq "CARD") {
      $device_loc="$Frame $Cage $CageType $DevType $Card";
    }
    if ($config_EliminationLevel[$x] eq "CHIP") {
      $device_loc="$Frame $Cage $CageType $DevType $Card $Chip";
    }
    if ($config_EliminationLevel[$x] eq "PORT") {
      $device_loc="$Frame $Cage $CageType $DevType $Card $Chip $Port";
    }
  } else {
    $device_loc="$Frame $Cage $CageType $DevType $Card $Chip $Port";
  }
  return $device_loc;
}

#-------------------------------------------------------------------
# Get Endpt locations
# Input:  Global Hex Endpt_List of Locations
# Output: Global Decimal Endpt locations(Endpt_Frame[]/Endpt_Cage[]...etc) 
#-------------------------------------------------------------------
sub getEndptLoc {
  my ($j);
  if ($#Endpt_List >= 0) {
    for ($j = 0; $j <= $#Endpt_List; $j++) {
      $firstzero=index($Endpt_List[$j],"0",0);
      $Endpt_List[$j]=substr($Endpt_List[$j], $firstzero, 16);
      # print "$j ENDPT=$Endpt_List[$j]\n";

      $Endpt_Frame[$j]=  hex(substr($Endpt_List[$j], 6,3));
      $pad=              substr("      ", 1, 6-length($Endpt_Frame[$j]));
      $Endpt_Frame[$j]=  "$Endpt_Frame[$j]$pad";

      $Endpt_Cage[$j]=   hex(substr($Endpt_List[$j],9,2)); 
      $pad=              substr("     ", 1, 5-length($Endpt_Cage[$j]));
      $Endpt_Cage[$j]=   "$Endpt_Cage[$j]$pad";

      $Endpt_CageType[$j]=hex(substr($Endpt_List[$j],11,1)); 
      if ($Endpt_CageType[$j] eq "0") { $Endpt_CageType[$j]="SWT"; }
      if ($Endpt_CageType[$j] eq "1") { $Endpt_CageType[$j]="CEC"; }
      if ($Endpt_CageType[$j] eq "2") { $Endpt_CageType[$j]="BPA"; }
      $pad=              substr("         ", 1, 9-length($Endpt_CageType[$j]));
      $Endpt_CageType[$j]="$Endpt_CageType[$j]$pad";

      $Endpt_DevType[$j]=hex(substr($Endpt_List[$j],12,1)); 
      if ($Endpt_DevType[$j] eq "2") { $Endpt_DevType[$j]="Adapter"; }
      if ($Endpt_DevType[$j] eq "3") { $Endpt_DevType[$j]="Switch"; }
      if ($Endpt_DevType[$j] eq "4") { $Endpt_DevType[$j]="Riser"; }
      $pad=              substr("        ", 1, 8-length($Endpt_DevType[$j]));
      $Endpt_DevType[$j]="$Endpt_DevType[$j]$pad";

      $Endpt_Card[$j]=   hex(substr($Endpt_List[$j],13,1)); 
      $pad=              substr("          ", 1, 10-length($Endpt_Card[$j]));
      $Endpt_Card[$j]=   "$Endpt_Card[$j]$pad";

      $Endpt_Chip[$j]=   hex(substr($Endpt_List[$j],14,1));
      $pad=              substr("         ", 1, 9-length($Endpt_Chip[$j]));
      $Endpt_Chip[$j]=   "$Endpt_Chip[$j]$pad";

      $Endpt_Port[$j]=   hex(substr($Endpt_List[$j],15,1));
      $pad=              substr("        ", 1, 8-length($Endpt_Port[$j]));
      $Endpt_Port[$j]=   "$Endpt_Port[$j]";
    }
  }
}

#-------------------------------------------------------------------
# Get Riser locations.
# Input:  Global Hex Riser_List of Locations
# Output: Global Decimal Riser locations(Riser_Frame[]/Riser_Cage[]...etc) 
#-------------------------------------------------------------------
sub getRiserLoc {
  my ($j);
  if ($#Riser_List >= 0) {
    for ($j = 0; $j <= $#Riser_List; $j++) {
      $firstzero=index($Riser_List[$j],"0",0);
      $Riser_List[$j]=substr($Riser_List[$j], $firstzero, 16);
      # print "$j RISER=$Riser_List[$j]\n";

      $Riser_Frame[$j]=  hex(substr($Riser_List[$j], 6,3));
      $pad=              substr("      ", 1, 6-length($Riser_Frame[$j]));
      $Riser_Frame[$j]=  "$Riser_Frame[$j]$pad";

      $Riser_Cage[$j]=   hex(substr($Riser_List[$j],9,2)); 
      $pad=              substr("     ", 1, 5-length($Riser_Cage[$j]));
      $Riser_Cage[$j]=   "$Riser_Cage[$j]$pad";

      $Riser_CageType[$j]=hex(substr($Riser_List[$j],11,1)); 
      if ($Riser_CageType[$j] eq "0") { $Riser_CageType[$j]="SWT"; }
      if ($Riser_CageType[$j] eq "1") { $Riser_CageType[$j]="CEC"; }
      if ($Riser_CageType[$j] eq "2") { $Riser_CageType[$j]="BPA"; }
      $pad=                substr("         ", 1, 9-length($Riser_CageType[$j]));
      $Riser_CageType[$j]="$Riser_CageType[$j]$pad";

      $Riser_DevType[$j]=hex(substr($Riser_List[$j],12,1)); 
      if ($Riser_DevType[$j] eq "2") { $Riser_DevType[$j]="Adapter"; }
      if ($Riser_DevType[$j] eq "3") { $Riser_DevType[$j]="Switch"; }
      if ($Riser_DevType[$j] eq "4") { $Riser_DevType[$j]="Riser"; }
      $pad=               substr("        ", 1, 8-length($Riser_DevType[$j]));
      $Riser_DevType[$j]="$Riser_DevType[$j]$pad";

      $Riser_Card[$j]=   hex(substr($Riser_List[$j],13,1)); 
      $pad=              substr("          ", 1, 10-length($Riser_Card[$j]));
      $Riser_Card[$j]=   "$Riser_Card[$j]$pad";

      $Riser_Chip[$j]=   hex(substr($Riser_List[$j],14,1));
      $pad=              substr("         ", 1, 9-length($Riser_Chip[$j]));
      $Riser_Chip[$j]=   "$Riser_Chip[$j]$pad";

      $Riser_Port[$j]=   hex(substr($Riser_List[$j],15,1));
      $pad=              substr("        ", 1, 8-length($Riser_Port[$j]));
      $Riser_Port[$j]=   "$Riser_Port[$j]";
    }
  }
}

#-------------------------------------------------------------------
# New Device and Network Events Equations
# Input:  New EventId, locations string in hex (with seq# and 
#         LocType in str) and minimun number locations required to  
#         to met New Event. 
#         
# Output: 
#         Global - $evt_used_in_NE[$Seq#]
#                  "BB10F00A-1" (Defaults to "N")  
#                - $evt_used_in_NE_loctype[$Seq#]
#                  "Dev or Endpt"   
#-------------------------------------------------------------------
sub New_Event {
  local($Event, $NE_LocStr, $min_num) = @_;
  my ($evt_seq, $evt_loctype, $evt_loc);
  my ($w, $x, $y, $z);

  #-------------------------------------------------------------------
  # Return if the number of locations is less then minimium required.
  #-------------------------------------------------------------------
  @NE_Locs = split(/,/ ,$NE_LocStr);
  if ($#NE_Locs >= $min_num) {
  } else {
    return;
  }

  # print "________________________________________________________________________________\n";
  # print ">>>>>> Pool=$pool_num  NE_num= $j  NE=$Event  #NE_Locs=$#NE_Locs  min_num=$min_num <<<<<<\n";
  # print "NE_LocStr     = $NE_LocStr\n";
  # print "________________________________________________________________________________\n";

  #------------------------------------------------------------
  # New Device Events
  #------------------------------------------------------------

  # Adapter 
  if ( ($Event eq "BB30F000") || ($Event eq "BB30F001") ) {
  }

  # Switch and Switch Riser
  if ( ($Event eq "BB10F00A") || ($Event eq "BB10F00B") ||
       ($Event eq "BB10F00F") || ($Event eq "BB10F010") ||
       ($Event eq "BB10F040") || ($Event eq "BB10F041") ||
       ($Event eq "BB50F014") ) {

    # Prio 1 and 2> Multi Chips and Ports on Unique Switch (int/ext)
    if ( ($Event eq "BB10F00A") || ($Event eq "BB10F00B") ) {
      $unique_chips_on_swt_min  = 6;
      $unique_ports_on_chip_min = 3;
    }

    # Prio 3> Multi Ports on Unique Switch Chips (int/ext)               
    if ( ($Event eq "BB10F00F") || ($Event eq "BB10F010") ) {
      $unique_chips_on_swt_min  = 1;
      $unique_ports_on_chip_min = 3;
    }

    # Prio 4> Multi Chips locs on any Switch (Frame/Cage or Chip Event)
    if ( ($Event eq "BB10F040") || ($Event eq "BB10F041") ) {
      $unique_chips_on_swt_min  = 2;
      $unique_ports_on_chip_min = 1;
      return;
    }

    # Prio 5> Both Riser card Ports (0 and 1 OR 2 and 3) on a unique Switch Chip
    if ($Event eq "BB50F014") {
      $unique_chips_on_swt_min  = 1;
      $unique_ports_on_chip_min = 2;
    }

    #-------------------------------------------------------------------
    # Create string of unique Switch Board Locations for all location
    # candidates.
    # Exclude Adapter endpts. Endpts are gathered for all switch events
    # in the event they are connected to another switch board.
    #-------------------------------------------------------------------
    $NE_Swt_LocStr = "";
    $Evt_set=0;
    for ($x = 1; $x <= $#NE_Locs; $x++) {
      ($evt_seq[$x], $evt_loctype[$x], $evt_loc[$x]) = split(/\s/, $NE_Locs[$x], 3);
      # print " evt_LogId[$evt_seq[$x]]=$evt_LogId[$evt_seq[$x]]  evt_loc[$x])=$evt_loc[$x]  $evt_loctype[$x]\n";
      $evt_swtloc = substr($evt_loc[$x],6,8);
      if ( ($NE_Swt_LocStr !~ /$evt_swtloc/) && (substr($evt_loc[$x],11,3) =~ /031/) ) {
        $NE_Swt_LocStr = "$NE_Swt_LocStr,$evt_swtloc";
      }  
    }
    @NE_Swt_Locs = split(/,/ ,$NE_Swt_LocStr);
    # print "\n Num_Swt_Locs=$#NE_Swt_Locs  Swt_LocStr=$NE_Swt_LocStr\n\n";
    #-------------------------------------------------------------------
    # Create a list of all locations for each unique switch location.
    #-------------------------------------------------------------------
    for ($y = 1; $y <= $#NE_Swt_Locs; $y++) {
      $NE_EvtIdStr[$y] = "";
      $Memb_SeqStr[$y] = "";
      $Memb_LocStr[$y] = "";
      $Memb_TypStr[$y] = "";
      for ($x = 1; $x <= $#NE_Locs; $x++) {
        if ($NE_Locs[$x] =~ /$NE_Swt_Locs[$y]/) {
          $Memb_SeqStr[$y] = "$Memb_SeqStr[$y],$evt_seq[$x]";
          $Memb_LocStr[$y] = "$Memb_LocStr[$y],$evt_loc[$x]";
          $Memb_TypStr[$y] = "$Memb_TypStr[$y],$evt_loctype[$x]";
        }
      }
      # print " Pool=$pool_num Event=$Event NE_Swt_Locs[$y]=$NE_Swt_Locs[$y]  Memb_LocStr[$y]=$Memb_LocStr[$y]  Memb_SeqStr[$y]=$Memb_SeqStr[$y]\n";
    }
    # print "\n";
    #-------------------------------------------------------------------
    # Create a list of unique chip locations for each unique switch location.
    #-------------------------------------------------------------------
    for ($y = 1; $y <= $#NE_Swt_Locs; $y++) {
      @Memb_Loc = split(/,/ ,$Memb_LocStr[$y]);
      @Memb_Seq = split(/,/ ,$Memb_SeqStr[$y]);
      $unique_chips[$y]=0;
      $Memb_swtchipStr[$y]="";
      for ($x = 1; $x <= $#Memb_Loc; $x++) {
        $Memb_swtchip = substr($Memb_Loc[$x],6,9);
        if ( ($Memb_swtchipStr[$y] !~ /$Memb_swtchip/)  &&
           ($evt_used_in_NE[$Memb_Seq[$x]] eq "N") ) {
          $Memb_swtchipStr[$y] = "$Memb_swtchipStr[$y],$Memb_swtchip";
          $unique_chips[$y]++;
        }  
      }
      # print " NE_Swt_Locs[$y]=$NE_Swt_Locs[$y], Memb_LocStr[$y]=$Memb_LocStr[$y]  Memb_swtchipStr=$Memb_swtchipStr[$y]  unique_chips[$y]=$unique_chips[$y]\n";
    }
    # print "\n";
    #-------------------------------------------------------------------
    # Create a list of unique port locations for each unique chip on a 
    # unique switch location.
    #-------------------------------------------------------------------
    for ($y = 1; $y <= $#NE_Swt_Locs; $y++) {
      # print " unique_chips[$y]=$unique_chips[$y]   >=   unique_chips_on_swt_min=$unique_chips_on_swt_min\n";
      if ($unique_chips[$y] >= $unique_chips_on_swt_min) {
        $Memb_swtchiportMetStr[$y]=0;
        $Memb_swtchiportsMet[$y]=0;
        @Memb_swtchip = split(/,/ ,$Memb_swtchipStr[$y]);
        for ($z = 1; $z <= $#Memb_swtchip; $z++) {
          $Memb_swtchiportStr[$z]="";
          $unique_chiports[$z]=0;
          @Memb_Seq = split(/,/ ,$Memb_SeqStr[$y]);
          @Memb_Loc = split(/,/ ,$Memb_LocStr[$y]);
          for ($x = 1; $x <= $#Memb_Loc; $x++) {
            $Memb_swtchiport = substr($Memb_Loc[$x],6,10);
            if ( ($Memb_swtchiport =~ /$Memb_swtchip[$z]/) && 
                 ($Memb_swtchiportStr[$z] !~ /$Memb_swtchiport/) &&
                 ($evt_used_in_NE[$Memb_Seq[$x]] eq "N") ) {
              $Memb_swtchiportStr[$z] = "$Memb_swtchiportStr[$z],$Memb_swtchiport";
              $unique_chiports[$z]++;
            }  
          }
          # print "Pool=$pool_num Event=$Event Memb_swtchiportStr[$z]=$Memb_swtchiportStr[$z] unique_chiports[$z]=$unique_chiports[$z]\n";
          if ($unique_chiports[$z] >= $unique_ports_on_chip_min) {
            # print " #### $unique_chips_on_swt_min unique chips on a switch had $unique_ports_on_chip_min unique ports\n";
            # All Event memebers of a specific switch
            @Memb_Loc = split(/,/ ,$Memb_LocStr[$y]);
            @Memb_Seq = split(/,/ ,$Memb_SeqStr[$y]);
            @Memb_Typ = split(/,/ ,$Memb_TypStr[$y]);
            # print " #### Memb_LocStr[$y]=$Memb_LocStr[$y]\n";
            # print " #### Memb_SeqStr[$y]=$Memb_SeqStr[$y]\n";
            # print " #### Memb_TypStr[$y]=$Memb_TypStr[$y]\n";

            #-------------------------------------------------------------------
            #  Bad Switch Riser Card                                                      
            #-------------------------------------------------------------------
            if ($Event eq "BB50F014") {
              @Memb_swtchiport=split(/,/ ,$Memb_swtchiportStr[$z]); 
              $Memb_swtchiport01Str = "";
              $Memb_swtchiport23Str = "";
              #------------------------------------------------
              # Create lists of ports 0 and 1 and ports 2 and 3
              #------------------------------------------------
              for ($w = 1; $w <= $#Memb_swtchiport; $w++) {
                $swtchiport = substr($Memb_swtchiport[$w],9,1);
                if (($swtchiport eq "0") || ($swtchiport eq "1")){ 
                  $Memb_swtchiport01Str = "$Memb_swtchiport01Str,$Memb_swtchiport[$w]";
                }
                if (($swtchiport eq "2") || ($swtchiport eq "3")){ 
                  $Memb_swtchiport23Str = "$Memb_swtchiport23Str,$Memb_swtchiport[$w]";
                }
              }
              @Memb_swtchiport01=split(/,/ ,$Memb_swtchiport01Str); 
              if ($#Memb_swtchiport01 == 2) {
                $Evt_set++;
                # print " #### $Event-$Evt_set\n";
                # For locations 0 and 1 met on a specific switch chip and port set globals
                for ($w = 1; $w <= $#Memb_swtchiport01; $w++) {
                  for ($x = 1; $x <= $#Memb_Loc; $x++) {
                    if ($Memb_Loc[$x] =~ /$Memb_swtchiport01[$w]/) {
                      $evt_used_in_NE[$Memb_Seq[$x]]         = "$Event-$Evt_set";
                      $evt_used_in_NE_loctype[$Memb_Seq[$x]] = "$Memb_Typ[$x]";
                      # print" #### evt_used_in_NE[$Memb_Seq[$x]]=$evt_used_in_NE[$Memb_Seq[$x]]  evt_used_in_NE_loctype[$Memb_Seq[$x]]=$evt_used_in_NE_loctype[$Memb_Seq[$x]]\n";
                      $Memb_Loc[$x] = "0000000000000000";
                    }
                  }   
                }
              }
              @Memb_swtchiport23=split(/,/ ,$Memb_swtchiport23Str); 
              if ($#Memb_swtchiport23 == 2) {
                $Evt_set++;
                # print " #### $Event-$Evt_set\n";
                # For locations 2 and 3 met on a specific switch chip and port set globals
                for ($w = 1; $w <= $#Memb_swtchiport23; $w++) {
                  for ($x = 1; $x <= $#Memb_Loc; $x++) {
                    if ($Memb_Loc[$x] =~ /$Memb_swtchiport23[$w]/) {
                      $evt_used_in_NE[$Memb_Seq[$x]]         = "$Event-$Evt_set";
                      $evt_used_in_NE_loctype[$Memb_Seq[$x]] = "$Memb_Typ[$x]";
                      # print" #### evt_used_in_NE[$Memb_Seq[$x]]=$evt_used_in_NE[$Memb_Seq[$x]]  evt_used_in_NE_loctype[$Memb_Seq[$x]]=$evt_used_in_NE_loctype[$Memb_Seq[$x]]\n";
                      $Memb_Loc[$x] = "0000000000000000";
                    }
                  }   
                }
              }
            }

            #-------------------------------------------------------------------
            #  Bad Switch Chip                                                      
            #-------------------------------------------------------------------
            if ( ($Event eq "BB10F00F") || ($Event eq "BB10F010") ) {
              $Evt_set++;
              @Memb_swtchiport=split(/,/ ,$Memb_swtchiportStr[$z]); 
              # print " #### $Event-$Evt_set\n";
              # For All locations met on a specific switch chip and port set globals
              for ($w = 1; $w <= $#Memb_swtchiport; $w++) {
                for ($x = 1; $x <= $#Memb_Loc; $x++) {
                  if ($Memb_Loc[$x] =~ /$Memb_swtchiport[$w]/) {
                    $evt_used_in_NE[$Memb_Seq[$x]]         = "$Event-$Evt_set";
                    $evt_used_in_NE_loctype[$Memb_Seq[$x]] = "$Memb_Typ[$x]";
                    # print" #### evt_used_in_NE[$Memb_Seq[$x]]=$evt_used_in_NE[$Memb_Seq[$x]]  evt_used_in_NE_loctype[$Memb_Seq[$x]]=$evt_used_in_NE_loctype[$Memb_Seq[$x]]\n";
                    $Memb_Loc[$x] = "0000000000000000";
                  }
                }   
              }
            }

            #-------------------------------------------------------------------
            #  Bad Switch Board                                                    
            #-------------------------------------------------------------------
            if ( ($Event eq "BB10F00A") || ($Event eq "BB10F00B") ) {
              $Memb_swtchiportsMet[$y]++;
              $Memb_swtchiportMetLocsStr[$y] = "$Memb_swtchiportMetLocsStr[$y],$Memb_swtchiportStr[$z]";
              $Memb_swtchiportMetLocsStr[$y] =~ s/\, *,/,/g;
            }
          }
          # print " NE_Swt_Locs[$y]=$NE_Swt_Locs[$y]  Memb_LocStr[$y]=$Memb_LocStr[$y]  Memb_swtchiportStr=$Memb_swtchiportStr[$z]  unique_chiports[$z]=$unique_chiports[$z] Memb_swtchiportsMet[$y]=$Memb_swtchiportsMet[$y]\n";
        }
        #-------------------------------------------------------------------
        # If condition is Met set Globals for all Events included in Met set.
        # Need Seq_num for all in Met set.
        #-------------------------------------------------------------------
        if ( ($Memb_swtchiportsMet[$y] >= $unique_chips_on_swt_min) && 
             (($Event eq "BB10F00A") || ($Event eq "BB10F00B")) ) {
          $Evt_set++;
          @Memb_swtchiportMetLocs=split(/,/ ,$Memb_swtchiportMetLocsStr[$y]);
          # print " #### $Event-$Evt_set\n";
          # For All locations met on a specific switch chip and port set globals
          for ($z = 1; $z <= $#Memb_swtchiportMetLocs; $z++) {
            for ($x = 1; $x <= $#Memb_Loc; $x++) {
              if ($Memb_Loc[$x] =~ /$Memb_swtchiportMetLocs[$z]/) {
                $evt_used_in_NE[$Memb_Seq[$x]]         = "$Event-$Evt_set";
                $evt_used_in_NE_loctype[$Memb_Seq[$x]] = "$Memb_Typ[$x]";
                # print" #### evt_used_in_NE[$Memb_Seq[$x]]=$evt_used_in_NE[$Memb_Seq[$x]]  evt_used_in_NE_loctype[$Memb_Seq[$x]]=$evt_used_in_NE_loctype[$Memb_Seq[$x]]\n";
                $Memb_Loc[$x] = "0000000000000000";
              }
            }
          }   
        }
      }
    }
  }

  #------------------------------------------------------------
  # New Network Events
  # All Prio 3                      
  #------------------------------------------------------------

  if ( ($Event eq "BB20F01E") || 
       ($Event eq "BB20F01F") || ($Event eq "BB20F020") ||
       ($Event eq "BB20F021") || ($Event eq "BB20F022") ||
       ($Event eq "BB20F023") || ($Event eq "BB20F024") ||
       ($Event eq "BB20F025") || ($Event eq "BB20F026") ||
       ($Event eq "BB20F027") || ($Event eq "BB20F028") ) {

    $Evt_set=0;
    $NE_Net_LocStr = "";
    #-------------------------------------------------------------------
    # Create string of unique Network Locations for all location
    # candidates.
    #-------------------------------------------------------------------
    for ($x = 1; $x <= $#NE_Locs; $x++) {
      ($evt_seq[$x], $evt_loctype[$x], $evt_loc[$x]) = split(/\s/, $NE_Locs[$x], 3);
      # print " evt_LogId[$evt_seq[$x]]=$evt_LogId[$evt_seq[$x]]  evt_loc[$x])=$evt_loc[$x]  $evt_loctype[$x]\n";
      @EndptList=split(/,/ ,$evt_DevEndptLocs[$evt_seq[$x]]);
      if ($EndptList[0] eq "") {
        $EndptList[0] = "0000000000000000";
      }
      $evt_endpt_netloc = substr($EndptList[0],6,10);
      $evt_netloc       = substr($evt_loc[$x],6,10);
      # print "evt_endpt_netloc=$evt_endpt_netloc\n";
      if ( ($NE_Net_LocStr !~ /$evt_netloc/) && ($NE_Net_LocStr !~ /$evt_endpt_netloc/) ){
        $NE_Net_LocStr = "$NE_Net_LocStr,$evt_netloc";
      }
    }
    @NE_Net_Locs = split(/,/ ,$NE_Net_LocStr);
    # print "\n Num_Net_Locs=$#NE_Net_Locs  Net_LocStr=$NE_Net_LocStr\n";
    if ($#NE_Net_Locs >= 2) {
      for ($x = 1; $x <= $#NE_Locs; $x++) {
        $evt_used_in_NE[$evt_seq[$x]]         = "$Event-$Evt_set";
        $evt_used_in_NE_loctype[$evt_seq[$x]] = "$Memb_Typ[$x]";
        # print"evt_used_in_NE[$evt_seq[$x]]=$evt_used_in_NE[$evt_seq[$x]]  evt_used_in_NE_loctype[$evt_seq[$x]]=$evt_used_in_NE_loctype[$evt_seq[$x]]\n";
      }
    }
  }

  return;
}

#-------------------------------------------------------------------
# Get New Device and New Network Event Equations
# Input  : New Event                           
# Returns: New Event Description
#-------------------------------------------------------------------
sub getAE_Expanded {
  my ($Event) = @_;

  %New_Event=(
       #------------------------------------------------------------
       # New Device Events
       #------------------------------------------------------------
       # BB10F040/1: Any of the events in the list must occur on at least 
       # 2 different chips. They need not be the same event on both chips.
       #------------------------------------------------------------
       # <!--  (New_Switch Events[64]) Multiple Chip Location Problem: Frame  -->
       'BB10F040', '2: BB10 Dev:A specific Switch has reported <2> or more Events associated
                    with this New Event where each occured on a unique Chip.',

       # <!--  (New_Switch Events[65]) Multiple Chip Location Problem: Cage or Chip  -->
       'BB10F041', '2: BB10 Dev:A specific Switch has reported <2> or more Events associated
                    with this New Event where each occured on a unique Chip.',
 
       # <!--  (New_Adapter Events[0]) suspect_AdpLDC  -->
       'BB30F000', '2: BB40 Dev,BB20 Endpt:2 unique Adapters on the same Card or Switches that are
                    endpts of these Adapters have reported <2> or more Events
                    associated with this new Event occurring on Adapters
                    0&1 or 2&3 or 4&5 or 6&7.',

       # <!--  (New_Switch Events[10]) suspect_swboardext  -->
       'BB10F00A', '18: BB20 Dev&Endpt,BB40 Endpt:A specific Switch or Switch/Adapter that is an endpt of this
                    specific Switch have reported <18> or more Events
                    associated with this new Event occurring on 3 unique Ports 
                    on 6 unique Switch Chips.',
        
       # <!--  (New_Switch Events[11]) suspect_swboardint  -->
       'BB10F00B', '18: BB20 Dev:A specific Switch has reported <18> or more Events
                    associated with this New Event occurring on 3 unique Ports 
                    on 6 unique Chips.',

       # <!--  (New_Switch Events[15]) suspect_swchipext  -->
       'BB10F00F', '3: BB20 Dev&Endpt,BB40 Endpt:A specific Switch or Switch/Adapter that is an endpt of this
                    specific Switch have reported <3> or more Events associated
                    with this New Event occurring on 3 unique Ports on a 
                    specfic Switch Chip.',

       # <!--  (New_Switch Events[16]) suspect_swchipint  -->
       'BB10F010', '3: BB20 Dev:A specific Switch has reported <3> or more Events associated
                    with this New Event occurring on 3 unique Ports on a unique
                    Switch Chip.', 

       # <!--  (New_Adapter Events[1]) suspect_adpcard  -->
       'BB30F001', '3: BB40 Dev,BB20 Endpt:A specific Adapter or Switch that is an endpt of this
                    specific Adapter have reported <3> or more Events associated 
                    with his New Event occurring on 3 unique Ports on a specific
                    Adapter Card.',

       # <!--  (New_Riser Events[20]) suspect_riser  -->
       'BB50F014', '2: BB20 Dev&Endpt,BB40 Endpt:A specific Switch or Switch/Adapter that is an endpt of this 
                    specfic Switch have reported <2> or more Events associated
                    with this New Event occurring on Switch Ports 0&1 or 2&3
                    on a unique Switch Chip.',

       #------------------------------------------------------------
       # New Network Events: 2 or more of ANY of the events in the 
       # list in 2 different locations. For Link devices we must
       # consider that the link may be connected to another link device   
       # included in the Network Event. This would be true for Network
       # events including a single event type of BB20 (switch-switch links) 
       # and Network events including multiple event types where
       # links may be conneceted (e.g. BB20 and BB40). Network events
       # should NOT include link and device events both since location    
       # uniqueness can not be determined (the device location
       # does not include the port). For BB20F01E we need a hard coded
       # adapter port of 0 (Adapter's currently ONLY have port 0).
       # Adapter Recovery already hard codes Adapter port to 0.
       #------------------------------------------------------------
       # <!--  (New_Network Events[30]) New hang_detect BB40/20/30  -->
       'BB20F01E', '2: BB20 Dev,BB40 Dev,BB30 Dev:An Adapter or Switch has reported <2> or more Events
                    associated with this New Event on unique Locations
                    *Note: Endpt connected Events are NOT unique.',

       # <!--  (New_Network Events[31]) New unconsumed_route BB30  -->
       'BB20F01F', '2: BB30 Dev:An Adapter has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[32]) New tod_master BB30  -->
       'BB20F020', '2: BB30 Dev:An Adapter has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[33]) New Receive MC Packet Too Long BB20  -->
       'BB20F021', '2: BB20 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[34]) New Missing Tail BB20  -->
       'BB20F022', '2: BB20 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[35]) New Chip ID Error  BB20  -->
       'BB20F023', '2: BB20 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[36]) New Invalid TOD Load Error BB20  -->
       'BB20F024', '2: BB20 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[37]) New Invalid TOD Propagate Error BB20  -->
       'BB20F025', '2: BB20 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[38]) New Service Array Overflow Error BB10 -->
       'BB20F026', '2: BB10 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[39]) New Undefined Service Command Error BB20  -->       
       'BB20F027', '2: BB20 Dev:A Switch has reported <2> or more Events associated with
                    this New Event on unique Locations.',

       # <!--  (New_Network Events[40]) New First Byte Error  BB30  -->
       'BB20F028', '2: BB30 Dev:An Adapter has reported <2> or more Events associated with
                    this New Event on unique Locations.',
  ); 

  while(($key,$value)=each %New_Event) {
    if ( $key eq "$Event" ) { $desc=$value }
  }
  return $desc;
}

#-----------------------------------------------------------------------------
# Calculate epoch. Coverts a datetime stamp to seconds.
# Input:   Dates in the format of 
#          - 10/28/04 08:13:14
#          - 11/20/2003 12:48:00
#          - Wed Nov 24 11:31:42 EST 2004
# Returns: Coverted datetime stamp in seconds  
#-----------------------------------------------------------------------------
sub epochTime {
  my ($timestring) = (@_);
  my $epoch="";
  %month=(
          '1', 'Jan',
          '2', 'Feb',
          '3', 'Mar',
          '4', 'Apr',
          '5', 'May',
          '6', 'Jun',
          '7', 'Jul',
          '8', 'Aug',
          '9', 'Sep',
          '10','Oct',
          '11','Nov',
          '12','Dec',
          );

  if ( $timestring =~ /(\d*)\/(\d*)\/(\d*) (\d*):(\d*):(\d*)/ ) {
        $mon=$1-1;
        $day=$2;
        $year=$3; $year=$year-1900;
        # print "In Short\n";
  } 
  if ( $timestring =~ /(\w*) (\w*) (\d*) (\d*):(\d*):(\d*) (\w*) (\d*)/ ) {
        while(($key,$value)=each %month) {
          if ( $value eq "$2" ) { $mon=$key-1 }
        }
        $day=$3;
        $year=$8; $year=$year-1900;
        # print "In Long\n";
  }
  if ( $year < 0 ) { $year=$year+2000 }
  $hour=$4;
  $min=$5;
  $sec=$6;
  $epoch=timegm($sec, $min, $hour, $day, $mon, $year);
  # print "1= $1, 2= $2, 3= $3, 4= $4, 5= $5, 6= $6, 7= $7, 8= $8, 9= $9, 10= $10\n";
  # print "sec=$sec, min=$min, $hour=hour, day=$day, mon=$mon, year=$year\n";

  return $epoch;
}

#-----------------------------------------------------------------------------
# Help!!!
#-----------------------------------------------------------------------------
sub StateFormat {
        print <<EOF;

Format: hw_errpt.pl -e [system event file] -c [ELA config file] -t [ time cutoff] -g [ time-out ] -s
  
        -i = points to the iqyylog.log that you want to look at

        -c = points to the config_FRS.xml that you want to look at

        -t = a cutoff time after which to look for events.
             Will ignore any event before the time given.
             e.g. "mm/dd/yy hh:mm:ss" with quotes

        -g = change timeout in seconds on all events. Default
             is 600 seconds or 5 minutes.

        -s = use slow pool time-out. Slow pool closes
             when last event in pool times out. Defaults
             to ELA fast where pool closes when first event
             in pool times out.

        -L = include Lodgical Locations in Summary Report for servicable Events

        -S = supress SFP Report                                       

        -h = help

EOF
        return;
}


